define("cp/component/annotation/reply",
    [
        "backbone",
        "cp/component/annotation/likes"
    ],
    function(
        Backbone,
        Likes
        ) {
        "use strict";

        var Reply = Backbone.Model.extend({
            defaults: {
                author: '',
                comment: '',
                date: new Date(),
                resolved: false,
                hasEditPermission: false,
                hasDeletePermission: false
            },
            initialize: function(attrs, opts) {
                // TODO: attrs undef?
                this.service = opts.service;
            },

            sync: function(method, model, options) {
                if (!this.service) {
                    return;
                }

                if (method === "create" || method === "update") {
                    var promise = model.service.save(model);
                    promise.done(function(savedModel) {
                        model.set(savedModel);
                        options.success();
                    }).fail(function(xhr) {
                        options.error(xhr);
                    });
                    return promise;
                } else if (method === "delete") {
                    var promise = model.service.remove(model);
                    promise.done(function(savedModel) {
                        options.success();
                    }).fail(function(xhr) {
                        options.error(xhr);
                    });
                    return promise;
                }
            }
    });

        return Reply;
    });