/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.previews.jwt;

import com.atlassian.confluence.plugins.previews.jwt.JwtTokenService;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.marshalling.jdk.JavaSerializationMarshalling;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettingsBuilder;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.VCacheFactory;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JwtLogHitService {
    static final String CACHE_NAME = "com.atlassian.confluence.plugins.previews.jwt.JwtUsageLogFilter";
    static final int CACHE_DURATION_SECONDS = 60;
    private static final Logger log = LoggerFactory.getLogger(JwtLogHitService.class);
    private JwtTokenService jwtTokenService;
    private VCacheFactory vCacheFactory;
    private DirectExternalCache<Boolean> cache;

    @Autowired
    public JwtLogHitService(JwtTokenService jwtTokenService, @ComponentImport VCacheFactory vCacheFactory) {
        this.jwtTokenService = jwtTokenService;
        this.vCacheFactory = Objects.requireNonNull(vCacheFactory);
        this.cache = this.createCache();
    }

    private DirectExternalCache<Boolean> createCache() {
        return this.vCacheFactory.getDirectExternalCache(CACHE_NAME, JavaSerializationMarshalling.pair(Boolean.class), new ExternalCacheSettingsBuilder().defaultTtl(Duration.ofSeconds(60L)).build());
    }

    private String getCacheKey(String user, String jwtId) {
        return String.format("%s,%s", user, jwtId);
    }

    public Future<Optional<Boolean>> isInCache(String userKey, String jwtId) {
        String cacheKey = this.getCacheKey(userKey, jwtId);
        return this.cache.get(cacheKey).toCompletableFuture();
    }

    public Future<Boolean> logHit(ServletRequest request) {
        JSONObject payload = this.jwtTokenService.extractJWTPayload(request);
        if (payload == null || !payload.has("jti") || !payload.has("userKey")) {
            return null;
        }
        String userKey = payload.getString("userKey");
        String jwtId = payload.getString("jti");
        return this.cache.put(this.getCacheKey(userKey, jwtId), (Object)true, PutPolicy.PUT_ALWAYS).toCompletableFuture();
    }
}

