define('confluence/page-hierarchy/util/analytics-event', [
    'ajs'
], function (AJS) {
    return {
        /**
         * Triggers an analytics event.
         * @param {string} name The name of the event
         *                      Needs to be whitelisted in analytics_whitelist.json
         * @returns {undefined}
         */
        publish: function analyticsEvent(name) {
            try {
                AJS.trigger('analyticsEvent', {
                    name: name,
                    data: {}
                });
            } catch (e) {
                // ¯\_(ツ)_/¯
            }
        },
        /************************************* DELETE ****************************************/
        /* When the flow is started. ie. Delete button clicked */
        DELETE_HIERARCHY_START_ANALYTICS_EVENT: 'confluence.page.hierarchy.delete.start',
        /* When the flow is started for an existing long-running task id */
        DELETE_HIERARCHY_START_EXISTING_ANALYTICS_EVENT: 'confluence.page.hierarchy.delete.start.existing',
        /* When the user clicks next after selecting to include child pages */
        DELETE_HIERARCHY_ANALYTICS_EVENT: 'confluence.page.hierarchy.delete.hierarchy',
        /* When the user clicks 'Delete' from the dialog (whether single page or with children) */
        DELETE_HIERARCHY_SUBMIT_ANALYTICS_EVENT: 'confluence.page.hierarchy.delete.hierarchy.submit',
        /* When the user clicks 'Back' from the preview dialog to go back to the initial dialog */
        DELETE_HIERARCHY_BACK_ANALYTICS_EVENT: 'confluence.page.hierarchy.delete.hierarchy.back',
        /* When the delete is done but either the user hasn't dismissed the flag, or there are errors to review */
        DELETE_HIERARCHY_DONE_ANALYTICS_EVENT: 'confluence.page.hierarchy.delete.done',
        /* When the entire flow is finished */
        DELETE_HIERARCHY_FINISHED_ANALYTICS_EVENT: 'confluence.page.hierarchy.delete.finished',
        /* If there are errors with pages and the user clicks 'View failed pages' */
        DELETE_HIERARCHY_VIEW_ERROR_ANALYTICS_EVENT: 'confluence.page.hierarchy.delete.view.errors',
        /* When the user sees the flag that some pages failed to delete */
        DELETE_FLAG_WARNING_SOME_PAGES_FAILED: 'confluence.page.hierarchy.delete.flag.warning.some.pages.failed',
        /* When the user sees an error dialog that the whole delete failed */
        DELETE_FLAG_ERROR_ALL_PAGES: 'confluence.page.hierarchy.delete.flag.error.all.pages',
        /* When the user sees the success flag on a successful deleted */
        DELETE_FLAG_SUCCESS: 'confluence.page.hierarchy.delete.flag.success',
        /* When the user closes the success/error flag */
        DELETE_CLOSE_FLAG: 'confluence.page.hierarchy.delete.close.flag',
        /* When the user cancels any of the delete dialogs */
        DELETE_HIERARCHY_CANCEL_ANALYTICS_EVENT: 'confluence.page.hierarchy.delete.cancel',
        /* When a user does not have read permission on a page to be deleted */
        DELETE_VALIDATION_INVALID_TARGET_ANALYTICS_EVENT: 'delete.page.hierarchy.dialog.invalid.target',
        /* When the user does not have delete permission on a page to be deleted */
        DELETE_VALIDATION_NO_DELETE_PAGE_PERMISSION_ANALYTICS_EVENT: 'delete.page.hierarchy.validation.noDeletePagePermission',
        /* When the user does not have space level permissions */
        DELETE_VALIDATION_INVALID_DELETE_HIERARCHY_ANALYTICS_EVENT: 'delete.page.hierarchy.dialog.invalid.deleteHierarchy',
        /* When the user tries to delete more than the maximum number of pages that can be deleted */
        DELETE_VALIDATION_MAX_PAGES_EXCEEDED_ANALYTICS_EVENT: 'delete.page.hierarchy.validation.maxPagesExceeded',
        /************************************* COPY ****************************************/
        /* When the flow is started. ie. Copy button clicked */
        COPY_HIERARCHY_START_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.start',
        /* When the user chooses to copy the page immediately without selecting children */
        COPY_PAGE_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.single.page',
        /* When the users advances from the location dialog to the preview dialog */
        COPY_HIERARCHY_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.hierarchy',
        /* When the user clicks submit on the preview dialog */
        COPY_HIERARCHY_SUBMIT_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.hierarchy.submit',
        /* When the user presses back from the preview dialog to return to the location dialog */
        COPY_HIERARCHY_BACK_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.hierarchy.back',
        /* When the user chooses to review errors */
        COPY_HIERARCHY_VIEW_ERROR_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.view.errors',
        /* If a space lock is hit the user has the option to choose a new location for their copy */
        COPY_HIERARCHY_CHOOSE_NEW_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.choose.new.location',
        /* When copy is done, but flow isn't yet finished (maybe have to review the errors still */
        COPY_HIERARCHY_DONE_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.done',
        /* When entire flow is finished */
        COPY_HIERARCHY_FINISHED_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.finished',
        /* When a new space is selected */
        COPY_NEW_SPACE_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.new.space.selected',
        /* When the user doesn't have permission to copy pages to the space they selected */
        COPY_NEW_SPACE_NO_PERMISSION_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.new.space.no.permission',
        /* When the user doesn't have permission to copy pages to the space they started with (the current space) */
        COPY_EXISTING_SPACE_NO_PERMISSION_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.existing.space.no.permission',
        /* When a new page is selected */
        COPY_NEW_PAGE_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.new.page.selected',
        /* If validation fails */
        COPY_VALIDATION_FAILED_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.validation.failed',
        /* When some page titles are too long */
        COPY_VALIDATION_TITLE_LENGTH_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.validation.title.length',
        /* When some page titles conflict in the destination space */
        COPY_VALIDATION_TITLE_CONFLICT_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.validation.title.conflict',
        /* When copying too many pages */
        COPY_VALIDATION_PAGE_LIMIT_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.validation.page.limit',
        /* When the destination page is somehow invalid. Maybe the page got deleted? */
        COPY_VALIDATION_INVALID_DESTINATION_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.validation.invalid.destination',
        /* When the origin page is somehow invalid. */
        COPY_VALIDATION_INVALID_ORIGIN_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.validation.invalid.origin',
        /* When the user doesn't have permission in the target space to create pages */
        COPY_VALIDATION_CREATE_PAGE_PERMISSION_ANALYTICS_EVENT: 'confluence.page.hierarchy.copy.validation.create.page.permission',
        /* When the user clicks the "View copied pages" link after the copy is finished */
        COPY_VIEW_COPIED_PAGES: 'confluence.page.hierarchy.copy.view.copied.pages',
        /* When the user closes the success/error flag */
        COPY_CLOSE_FLAG: 'confluence.page.hierarchy.copy.close.flag',
        /* When the user sees the success flag */
        COPY_FLAG_SUCCESS: 'confluence.page.hierarchy.copy.flag.success',
        /* When the user sees the error flag and no pages were copied */
        COPY_FLAG_ERROR_ALL_PAGES: 'confluence.page.hierarchy.copy.flag.error.all.pages',
        /* When the user sees the error flag because someone else is already copying pages to the space */
        COPY_FLAG_ERROR_LOCK: 'confluence.page.hierarchy.copy.flag.error.lock',
        /* When the user sees the warning flag because the pages were copied but the links failed to be updated */
        COPY_FLAG_WARNING_RELINKING_PAGES: 'confluence.page.hierarchy.copy.flag.warning.links',
        /* When the user sees the warning flag because some pages weren't copied */
        COPY_FLAG_WARNING_SOME_PAGES_FAILED: 'confluence.page.hierarchy.copy.flag.warning.some.pages.failed',
        /* When the user sees the warning flag because some pages weren't copied and links failed to be updated */
        COPY_FLAG_WARNING_SOME_PAGES_FAILED_RELINKING_PAGES: 'confluence.page.hierarchy.copy.flag.warning.some.pages.failed.and.links',
        /* When children in the preview are expanded */
        PREVIEW_EXPAND_CHILDREN: 'confluence.page.hierarchy.preview.children.expand',
        /* When children in the preview are collapsed */
        PREVIEW_COLLAPSE_CHILDREN: 'confluence.page.hierarchy.preview.children.collapse'
    };
});