/**
 * This is the source of truth.
 */
define('confluence/page-hierarchy/state/copy-state',
    [
        'ajs'
    ], function (AJS) {
        // Triggered when a user selects to copy just the current page
        var COPY_PAGE_EVENT = 'copy-page-hierarchy-plugin:copy-page';
        // Triggered when the user selects to copy a page and its children
        var COPY_HIERARCHY_EVENT = 'copy-page-hierarchy-plugin:copy-page-hierarchy';
        // Triggered when the user presses back to return to the destination selector
        var COPY_HIERARCHY_BACK_EVENT = 'copy-page-hierarchy-plugin:copy-page-hierarchy-back';
        // Triggered when the user successfully submits from the copy hierarchy dialog
        var COPY_HIERARCHY_SUBMIT_EVENT = 'copy-page-hierarchy-plugin:copy-page-hierarchy-submit';
        // Triggered when a copy completes whether successfully or with errors
        var COPY_HIERARCHY_DONE_EVENT = 'copy-page-hierarchy-plugin:copy-page-hierarchy-done';
        // Triggered when a users chooses to review any errors that may have occurred
        var COPY_HIERARCHY_VIEW_ERROR_EVENT = 'copy-page-hierarchy-plugin:copy-page-hierarchy-view-error';
        // Triggered when the user has finished reviewing everything and exited the process
        var FINISHED_EVENT = 'copy-page-hierarchy-plugin:copy-page-hierarchy-finished';
        // Triggered when a space lock on the copy operation makes the operation fail
        // and the user chooses to choose a new location
        var COPY_HIERARCHY_CHOOSE_NEW_EVENT = 'copy-page-hierarchy-plugin:choose-new';

        var DEFAULT_COPY_ATTACHMENTS_VALUE = true;
        var DEFAULT_COPY_PERMISSIONS_VALUE = true;
        var DEFAULT_COPY_LABELS_VALUE = true;

        var options = {};
        var state = {};
        var errors = [];
        var warnings = [];
        var permissions = [];

        reset();

        function reset() {
            options = {
                copyAttachments: DEFAULT_COPY_ATTACHMENTS_VALUE,
                copyPermissions: DEFAULT_COPY_PERMISSIONS_VALUE,
                copyLabels: DEFAULT_COPY_LABELS_VALUE,
                titleOptions: {
                    prefix: '',
                    search: '',
                    replace: ''
                },
                originalPageId: AJS.Meta.get('page-id'),
                destinationPageId: ''
            };
            state = {
                anyPagesCopied: false,
                includeChildren: false,
                copyAttachments: DEFAULT_COPY_ATTACHMENTS_VALUE,
                taskId: '',
                destinationSpaceKey: '',
                destinationPageTitle: '',
                destinationPageUrl: ''
            };
            errors = [];
            warnings = [];
            permissions = [];
        }

        function getOptions() {
            return options;
        }

        function getState() {
            return state;
        }

        function getErrors() {
            return errors;
        }

        function setErrors(err) {
            errors = err;
        }

        function clearErrors() {
            errors = [];
            warnings = [];
        }

        function getWarnings() {
            return warnings;
        }

        function setWarnings(warn) {
            warnings = warn;
        }

        function getPermissions() {
            return permissions;
        }

        function setPermissions(perms) {
            permissions = perms;
        }

        function setCopyAttachments(value) {
            options.copyAttachments = !!value;
        }

        function setCopyPermissions(value) {
            options.copyPermissions = !!value;
        }

        function setCopyLabels(value) {
            options.copyLabels = !!value;
        }

        function setTitlePrefix(value) {
            options.titleOptions.prefix = value;
        }

        function setSearchString(value) {
            options.titleOptions.search = value;
        }

        function setReplaceString(value) {
            options.titleOptions.replace = value;
        }

        function setDestinationPageId(pageId) {
            options.destinationPageId = pageId;
        }

        function setIncludeChildren(value) {
            state.includeChildren = !!value;
        }

        function setTaskId(taskId) {
            state.taskId = taskId;
        }

        function setDestinationPageTitle(pageTitle) {
            state.destinationPageTitle = pageTitle;
        }

        function setDestinationSpaceKey(key) {
            state.destinationSpaceKey = key;
        }

        function setDestinationPageUrl(url) {
            state.destinationPageUrl = url;
        }

        function setAnyPagesCopied(value) {
            state.anyPagesCopied = !!value;
        }

        function setCopyAttachmentsTopPage(value) {
            state.copyAttachments = !!value;
        }

        return {
            FINISHED_EVENT: FINISHED_EVENT,
            COPY_HIERARCHY_EVENT: COPY_HIERARCHY_EVENT,
            COPY_PAGE_EVENT: COPY_PAGE_EVENT,
            COPY_HIERARCHY_BACK_EVENT: COPY_HIERARCHY_BACK_EVENT,
            COPY_HIERARCHY_SUBMIT_EVENT: COPY_HIERARCHY_SUBMIT_EVENT,
            COPY_HIERARCHY_DONE_EVENT: COPY_HIERARCHY_DONE_EVENT,
            COPY_HIERARCHY_VIEW_ERROR_EVENT: COPY_HIERARCHY_VIEW_ERROR_EVENT,
            COPY_HIERARCHY_CHOOSE_NEW_EVENT: COPY_HIERARCHY_CHOOSE_NEW_EVENT,
            getOptions: getOptions,
            getState: getState,
            getErrors: getErrors,
            setErrors: setErrors,
            getWarnings: getWarnings,
            setWarnings: setWarnings,
            getPermissions: getPermissions,
            setPermissions: setPermissions,
            setCopyAttachments: setCopyAttachments,
            setCopyPermissions: setCopyPermissions,
            setCopyLabels: setCopyLabels,
            setTitlePrefix: setTitlePrefix,
            setSearchString: setSearchString,
            setReplaceString: setReplaceString,
            setDestinationPageId: setDestinationPageId,
            setIncludeChildren: setIncludeChildren,
            setDestinationPageTitle: setDestinationPageTitle,
            setDestinationPageUrl: setDestinationPageUrl,
            setTaskId: setTaskId,
            setDestinationSpaceKey: setDestinationSpaceKey,
            setAnyPagesCopied: setAnyPagesCopied,
            reset: reset,
            clearErrors: clearErrors,
            setCopyAttachmentsTopPage: setCopyAttachmentsTopPage
        };

    });