define('confluence/page-hierarchy/flow/copy-flow', [
    'ajs',
    'confluence/page-hierarchy/state/copy-state',
    'confluence/page-hierarchy/dialog/copy-dialog',
    'confluence/page-hierarchy/dialog/copy-hierarchy-dialog',
    'confluence/page-hierarchy/dialog/copy-progress-dialog',
    'confluence/page-hierarchy/dialog/copy-error-dialog',
    'confluence/page-hierarchy/util/analytics-event'
], function (AJS,
             state,
             copyDialog,
             copyHierarchyDialog,
             progressDialog,
             errorDialog,
             analyticsEvent) {
    var COPY_PAGE_ACTION = '/pages/copypage.action';

    // Copy Dialog
    AJS.bind(state.COPY_PAGE_EVENT, function () {
        _copyPage();
        analyticsEvent.publish(analyticsEvent.COPY_PAGE_ANALYTICS_EVENT);
    });
    AJS.bind(state.COPY_HIERARCHY_EVENT, function () {
        copyDialog.hide();
        copyHierarchyDialog.show();
        analyticsEvent.publish(analyticsEvent.COPY_HIERARCHY_ANALYTICS_EVENT);
    });

    // Copy Hierarchy Dialog
    AJS.bind(state.COPY_HIERARCHY_SUBMIT_EVENT, function () {
        copyHierarchyDialog.hide();
        progressDialog.show();
        analyticsEvent.publish(analyticsEvent.COPY_HIERARCHY_SUBMIT_ANALYTICS_EVENT)
    });
    AJS.bind(state.COPY_HIERARCHY_BACK_EVENT, function () {
        copyHierarchyDialog.hide();
        copyDialog.show();
        analyticsEvent.publish(analyticsEvent.COPY_HIERARCHY_BACK_ANALYTICS_EVENT);
    });

    // Progress
    AJS.bind(state.COPY_HIERARCHY_VIEW_ERROR_EVENT, function () {
        errorDialog.show();
        analyticsEvent.publish(analyticsEvent.COPY_HIERARCHY_VIEW_ERROR_ANALYTICS_EVENT)
    });
    AJS.bind(state.COPY_HIERARCHY_DONE_EVENT, function () {
        progressDialog.hide();
        analyticsEvent.publish(analyticsEvent.COPY_HIERARCHY_DONE_ANALYTICS_EVENT);
    });
    AJS.bind(state.COPY_HIERARCHY_CHOOSE_NEW_EVENT, function () {
        copyDialog.show();
        analyticsEvent.publish(analyticsEvent.COPY_HIERARCHY_CHOOSE_NEW_ANALYTICS_EVENT);
    });

    // Finished
    AJS.bind(state.FINISHED_EVENT, function () {
        copyDialog.remove();
        copyHierarchyDialog.remove();
        progressDialog.remove();
        errorDialog.remove();

        state.reset();
        analyticsEvent.publish(analyticsEvent.COPY_HIERARCHY_FINISHED_ANALYTICS_EVENT);
    });

    function startFlow() {
        copyDialog.show();
        analyticsEvent.publish(analyticsEvent.COPY_HIERARCHY_START_ANALYTICS_EVENT);
    }

    function _copyPage() {
        window.location = AJS.contextPath() + COPY_PAGE_ACTION
            + '?idOfPageToCopy=' + state.getOptions().originalPageId
            + '&idOfPageToCopyTo=' + state.getOptions().destinationPageId
            + '&spaceKey=' + state.getState().destinationSpaceKey
            + '&copyAttachments=' + state.getState().copyAttachments;
    }

    return {
        startFlow: startFlow
    }
});