define('confluence/ob/modules/tutorial/remove-demo-space/remove-demo-space-sequence', [
    'jquery',
    'confluence/ob/common/promise',
    'aui/flag'
], function($, Promise, Flag) {
    'use strict';

    var RemoveDemoSpaceSequence = function(options) {};

    RemoveDemoSpaceSequence.prototype.init = function(container, analytics) {

        return Promise(function(resolve) {
            function showNotificationFlag() {
                Flag({
                    type: 'info',
                    title: AJS.I18n.getText('onboarding.sequence.removeSpace.title', spaceKey),
                    body: Confluence.Templates.OB.removeSpaceNotification({
                        'dashboardUrl': AJS.contextPath() + '/dashboard.action'
                    }),
                    persistent: false,
                    close: 'never'
                });
            }

            var spaceKey = sessionStorage.getItem('created-space-key');

            $.ajax({
                type: "DELETE",
                dataType: "json",
                contentType: "application/json",
                url: AJS.contextPath() + '/rest/api/space/' + spaceKey,
                success: showNotificationFlag
            });

            resolve();
        });
    };

    return RemoveDemoSpaceSequence;
});
