define('confluence/ob/modules/intro/warm-editor-resources', [
    'ajs',
    'jquery'
], function (AJS, $) {
    /**
     * This module simulates the editor tour page load, by loading the actual page in an iframe
     * in a different space from what the user creates. This caches all the resources on that page,
     * reducing the average wait time (under 60) between the intro tutorial and the editor tour from 11 seconds
     * to 7 seconds and improves engagement in the tutorial.
     * See: https://extranet.atlassian.com/display/PGT/GROW-3003%3A+Improving+editor+load+times+in+Confluence+Onboarding
     *
     * We went through a few ideas and iterations but nothing really worked to cache the correct resources because of
     * the way WRM currently handles URL-generation for batches of resources. Only the actual page-load was adequate
     * to get the right resources.
     */
    var warmResources = function () {
        var deferred = $.Deferred();
        var timeout = 30000;

        setTimeout(function () {
            deferred.reject();
        }, timeout);

        setTimeout(function () {
            getDemoSpaceExists().fail(function () {
                deferred.reject();
            }).done(function () {
                var iframe, iframeWindow;

                iframe = document.createElement('iframe');

                /** Simulate the actual request that will happen at the end of the flow to get the right
                 resources. Use the Demonstration Space */
                $.cookie('load-tutorial-flow', 'true', {path: '/'});
                iframe.src = AJS.contextPath() + '/pages/createpage.action?spaceKey=ds';
                // display=none causes an issue in firefox
                //iframe.style.display = 'none';
                iframe.width = 0;
                iframe.height = 0;
                iframe.style.visibility = 'hidden';

                $('body').append(iframe);

                iframeWindow = iframe.contentWindow || iframe;

                // Once we know the resources have downloaded, discard the draft and destroy the iframe
                $(iframeWindow).load(function () {
                    var draftId = iframeWindow.AJS.Meta.get('content-id');
                    iframeWindow.Confluence.Editor.Drafts.discardDraft(draftId).always(function () {
                        // Fixes IE iframe issues
                        iframe.src = '';
                        setTimeout(function () {
                            iframe.parentNode.removeChild(iframe);
                        }, 0);
                        $.cookie('load-tutorial-flow', null, {path: '/'});
                        deferred.resolve();
                    });

                });
            });

        }, 50);

        return deferred.promise();
    };

    function getDemoSpaceExists() {
        var deferred = $.Deferred();
        $.ajax({
            url: AJS.contextPath() + '/rest/api/space?spaceKey=ds',
            success: function (resultSet) {
                if (resultSet && resultSet.results && resultSet.results.length) {
                    deferred.resolve();
                } else {
                    deferred.reject();
                }
            },
            error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

    return warmResources;
});