/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.services;

import com.atlassian.confluence.efi.services.OnboardingSpaceImportObjectPreProcessor;
import com.atlassian.confluence.efi.services.SpaceImportConfig;
import com.atlassian.confluence.efi.services.SpaceService;
import com.atlassian.confluence.importexport.DefaultImportContext;
import com.atlassian.confluence.importexport.ImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportExportManager;
import com.atlassian.confluence.importexport.ImportedObjectPreProcessor;
import com.atlassian.confluence.importexport.actions.ImportLongRunningTask;
import com.atlassian.confluence.search.lucene.ConfluenceIndexManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class SpaceServiceImpl
implements SpaceService {
    private final SpaceManager spaceManager;
    private final ImportExportManager importExportManager;
    private final ConfluenceIndexManager indexManager;
    private final EventPublisher eventPublisher;
    private final SpacePermissionManager spacePermissionManager;
    private final SettingsManager settingsManager;
    private final PermissionManager permissionManager;

    public SpaceServiceImpl(SpaceManager spaceManager, ImportExportManager importExportManager, ConfluenceIndexManager indexManager, EventPublisher eventPublisher, SpacePermissionManager spacePermissionManager, SettingsManager settingsManager, PermissionManager permissionManager) {
        this.spaceManager = spaceManager;
        this.importExportManager = importExportManager;
        this.indexManager = indexManager;
        this.eventPublisher = eventPublisher;
        this.spacePermissionManager = spacePermissionManager;
        this.settingsManager = settingsManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public URL getOnboardingSpaceZipURL() {
        return this.getClass().getResource("/onboarding-space.zip");
    }

    @Override
    public String createUniqueSpaceKey(String key) {
        Collection spaceKeys = this.spaceManager.getAllSpaceKeys(SpaceStatus.CURRENT);
        spaceKeys.addAll(this.spaceManager.getAllSpaceKeys(SpaceStatus.ARCHIVED));
        HashSet keyMap = Sets.newHashSet();
        for (String spaceKey : spaceKeys) {
            keyMap.add(spaceKey.toUpperCase());
        }
        return this.findUniqueKey(keyMap, key.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importAndReindex(URL onboardingSpaceZipUrl, SpaceImportConfig importConfig) throws ImportExportException {
        ConfluenceUser authenticated = AuthenticatedUserThreadLocal.get();
        try {
            DefaultImportContext importContext = this.createImportContext(onboardingSpaceZipUrl, importConfig);
            ImportLongRunningTask task = new ImportLongRunningTask(this.eventPublisher, this.indexManager, this.importExportManager, (ImportContext)importContext);
            task.run();
            if (!task.isSuccessful()) {
                throw new ImportExportException("Import onboarding space task failed");
            }
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)authenticated);
        }
        this.updateSpaceCreatorAndPermissions(importConfig.getSpaceKey(), importConfig.getActor(), importConfig.isTemporary());
    }

    private DefaultImportContext createImportContext(URL onboardingSpaceZipUrl, SpaceImportConfig importConfig) {
        DefaultImportContext importContext = new DefaultImportContext(onboardingSpaceZipUrl, importConfig.getActor());
        importContext.setPreProcessor((ImportedObjectPreProcessor)new OnboardingSpaceImportObjectPreProcessor(importConfig));
        importContext.setDefaultUsersGroup("confluence-users");
        importContext.setSpaceKeyOfSpaceImport(importConfig.getSpaceKey());
        importContext.setIncrementalImport(true);
        importContext.setRebuildIndex(false);
        return importContext;
    }

    private void updateSpaceCreatorAndPermissions(String spaceKey, ConfluenceUser user, boolean temporary) {
        Space sp = this.spaceManager.getSpace(spaceKey);
        if (sp == null) {
            return;
        }
        sp.setCreator(user);
        if (temporary && sp.getDescription() != null) {
            sp.getDescription().setBodyAsString("efionboardingspace");
        }
        this.spaceManager.saveSpace(sp);
        if (this.permissionManager.isConfluenceAdministrator((User)user)) {
            this.fixPermissionsOfSpace(sp, user);
        }
    }

    private void fixPermissionsOfSpace(Space space, ConfluenceUser user) {
        ArrayList oldSpacePermissions = Lists.newArrayList((Iterable)space.getPermissions());
        for (SpacePermission oldPermission : oldSpacePermissions) {
            this.spacePermissionManager.removePermission(oldPermission);
        }
        for (String permissionStr : SpacePermission.GENERIC_SPACE_PERMISSIONS) {
            this.spacePermissionManager.savePermission(new SpacePermission(permissionStr, space, "confluence-administrators"));
            if (user != null) {
                this.spacePermissionManager.savePermission(SpacePermission.createUserSpacePermission((String)permissionStr, (Space)space, (ConfluenceUser)user));
            }
            if (!"SETSPACEPERMISSIONS".equals(permissionStr)) {
                this.spacePermissionManager.savePermission(new SpacePermission(permissionStr, space, this.settingsManager.getGlobalSettings().getDefaultUsersGroup()));
            }
            if (SpacePermission.INVALID_ANONYMOUS_PERMISSIONS.contains(permissionStr)) continue;
            this.spacePermissionManager.savePermission(new SpacePermission(permissionStr, space));
        }
    }

    private String findUniqueKey(Collection<String> keyMap, String currentKey) {
        if (!keyMap.contains(currentKey)) {
            return currentKey;
        }
        for (int i = 1; i < 999; ++i) {
            String key = currentKey + i;
            if (keyMap.contains(key)) continue;
            return key;
        }
        return null;
    }
}

