define('confluence/ob/common/promise',
    ['jquery', 'underscore'],
function($, _) {

    function Promise(resolver) {
       var promise = $.Deferred(),
           resolve = _.bind(promise.resolve, promise),
           reject = _.bind(promise.reject, promise);

       if (typeof resolver !== 'function') {
           throw Error('Argument resolver must be a function');
       }

       resolver(resolve, reject);

       return promise.promise();
    }

    return Promise;
});