define('confluence/ob/modules/intro/intro-upload-avatar-sequence', [
    'jquery',
    'confluence/ob/common/promise',
    'confluence/ob/modules/intro/intro-sequence-utils',
    'confluence-user-profile/avatar-picker/avatar-picker-panel'
], function ($, Promise, IntroSequenceUtils, AvatarPickerPanel) {
    'use strict';

    var IntroUploadAvatarSequence = function(options) {};

    IntroUploadAvatarSequence.prototype.init = function(container, analytics) {
        /**
         * Reject when user choose to skip this step
         */
        return Promise(function(resolve, reject) {
            var $contentEl = IntroSequenceUtils.createProgressTracker('upload-avatar');
            $contentEl.append(Confluence.Templates.OB.avatarUploadHolder());

            $(".uploader-buttons-container button").click(function(e) {
                e.preventDefault();
            });

            $contentEl.find('button[data-action=skip]').click(function() {
                analytics.pushEvent(EVENTS.SKIP_CLICKED);
                reject("skip");
            });

            var panel = new AvatarPickerPanel({
                panel: $contentEl.find('.avatar-cropper-container'),
                saveButton: $contentEl.find('button[data-action=save]'),
                onCrop: function(croppedDataURI) {
                    $('button[data-action=save]').prop('disabled', true);
                    $('.grow-intro-avatar-button-spinner').spin();
                    // send off the croppedDataURI to Java land...
                    $.ajax({
                        type:'POST',
                        dataType:"json",
                        contentType:"application/json",
                        data: JSON.stringify({
                            avatarDataURI: croppedDataURI
                        }),
                        url: AJS.Meta.get('context-path') + '/rest/user-profile/1.0/' + AJS.Meta.get('remote-user-key') + '/avatar/upload',
                        success: function(data) {
                            analytics.pushEvent(EVENTS.SAVE_SUCCESS);
                            resolve('uploaded');
                        },
                        error:function (xhr) {
                            $('button[data-action=save]').prop('disabled', false);
                            analytics.pushEvent(EVENTS.SAVE_FAILED);
                            panel.setMessage(AJS.I18n.getText('user.avatar.picker.upload.error'));
                        }
                    }).always(function() {
                        $('.grow-intro-avatar-button-spinner').spinStop();
                    });
                },
                onExpanded: function() {
                    analytics.pushEvent(EVENTS.CHOOSE_FILE);
                }
            });
        });
    };

    var EVENTS = {
        SAVE_FAILED: "intro.avatar.save.failed",
        SAVE_SUCCESS: "intro.avatar.save.success",
        CHOOSE_FILE: "intro.avatar.choose.file",
        SKIP_CLICKED: "intro.avatar.skip.clicked"
    };

    return IntroUploadAvatarSequence;
});