var SessionProgressTracker = require('confluence/ob/flow/controller/session-progress-tracker');
var flowKey = "tutorialFlow";
var EDITOR_STEP_KEY = 'editorTour';
var COMPLETED_STEP_KEY = "__complete__";

SessionProgressTracker.getCurrentFlowSequence(flowKey).done(function (step) {
    if (step && step !== COMPLETED_STEP_KEY) {

        // This function will make sure that our tour won't be bothered by other discovery feature.
        postponeOtherDiscoveryFeatures();

        AJS.toInit(function() {
            var loadingIndicator = Confluence.PageLoadingIndicator($("body"));

            if (step === EDITOR_STEP_KEY && isCreatingNewPage()) {
                loadingIndicator.show();

                // We don't wanna show any message at this moment, except editor message
                $('.aui-message:not(#editor-notifications-container .aui-message)').hide();
            }

            WRM.require("wr!com.atlassian.confluence.plugins.confluence-onboarding:confluence-flow-resources")
                    .done(function () {
                        loadingIndicator.hide();
                        var SequenceController = require('confluence/ob/flow/controller/sequence-controller'),
                                DashboardFlow = require('confluence/ob/flow/main/tutorial-workflow');
                        var sequenceController = new SequenceController({
                            container: $("<div>").appendTo(document.body)[0],
                            flow: DashboardFlow,
                            flowKey: flowKey,
                            progressTracker: SessionProgressTracker
                        });

                        sequenceController.start(step);
                    });
        });
    }

    function isCreatingNewPage() {
        return window.location.href.indexOf('/pages/createpage.action?') !== -1;
    }

    /**
     * This function must be executed before DOM is ready.
     * By calling shouldShow method, we force setting featureShown variable to true to prevent other discovery feature can show.
     */
    function postponeOtherDiscoveryFeatures() {
        var pluginKey = 'com.atlassian.confluence.plugins.confluence-onboarding';
        var fakeDiscovery = Confluence.FeatureDiscovery.forPlugin(pluginKey);
        fakeDiscovery.shouldShow(pluginKey, false);
    }
});
