define('confluence/ob/flow/controller/flow-progress-tracker', [
    'jquery',
    'underscore',
    'confluence/ob/common/storage/server-storage'
], function ($, _, ServerStorage) {
    'use strict';

    function buildStorageKey(flowKey) {
        return "onboarding-state:" + flowKey;
    }

    return {
        completeFlow: function(flowKey) {
            return ServerStorage.set(buildStorageKey(flowKey), "__complete__");
        },

        setCurrentFlowSequence: function(flowKey, sequenceKey) {
            return ServerStorage.set(buildStorageKey(flowKey), sequenceKey);
        },

        getCurrentFlowSequence: function(flowKey) {
            return ServerStorage.get(buildStorageKey(flowKey));
        }
    }
});