/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.efi.emails.scheduling;

import com.atlassian.confluence.efi.emails.events.OnboardingEvent;
import com.atlassian.confluence.efi.store.GlobalStorageService;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.quartz.jobs.AbstractJob;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Group;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class AbstractOnboardingJob
extends AbstractJob {
    private static String JOB_STATUS_FIRST_EXECUTE = "JOB_FIRST_EXECUTE";
    private static String JOB_STATUS_EXECUTED = "JOB_EXECUTED";
    protected final UserAccessor userAccessor;
    protected final EventPublisher eventPublisher;
    protected final CrowdService crowdService;
    protected final GlobalStorageService globalStorageService;

    public AbstractOnboardingJob(UserAccessor userAccessor, EventPublisher eventPublisher, CrowdService crowdService, GlobalStorageService globalStorageService) {
        this.userAccessor = userAccessor;
        this.eventPublisher = eventPublisher;
        this.crowdService = crowdService;
        this.globalStorageService = globalStorageService;
    }

    public void doExecute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String jobName = jobExecutionContext.getJobDetail().getName();
        String jobStatus = this.globalStorageService.get(jobName);
        if (StringUtils.equals((CharSequence)jobStatus, (CharSequence)JOB_STATUS_EXECUTED)) {
            return;
        }
        if (jobStatus == null) {
            this.globalStorageService.set(jobName, JOB_STATUS_FIRST_EXECUTE);
            return;
        }
        this.globalStorageService.set(jobName, JOB_STATUS_EXECUTED);
        this.doExecute();
    }

    protected void triggerEvent() {
        ConfluenceUser firstAdmin = (ConfluenceUser)this.getFirstAdmin().getOrNull();
        this.eventPublisher.publish((Object)this.createEventForUser(firstAdmin.getKey()));
    }

    protected abstract void doExecute();

    protected abstract OnboardingEvent createEventForUser(UserKey var1);

    private Maybe<ConfluenceUser> getFirstAdmin() {
        ConfluenceUser firstAdminConfUser = null;
        Group adminGroup = this.userAccessor.getGroup("confluence-administrators");
        ImmutableList confluenceUsers = ImmutableList.copyOf((Iterable)this.userAccessor.getMembers(adminGroup));
        if (!Iterables.isEmpty((Iterable)confluenceUsers)) {
            Iterable users = Iterables.transform((Iterable)confluenceUsers, input -> this.crowdService.getUser(input.getName()));
            Iterable sortedUsers = Iterables.mergeSorted((Iterable)ImmutableList.of((Object)users), (u1, u2) -> {
                if (u1 instanceof TimestampedUser && u2 instanceof TimestampedUser) {
                    TimestampedUser user1 = (TimestampedUser)u1;
                    TimestampedUser user2 = (TimestampedUser)u2;
                    return user1.getCreatedDate().compareTo(user2.getCreatedDate());
                }
                return 0;
            });
            User firstAdmin = (User)sortedUsers.iterator().next();
            firstAdminConfUser = this.userAccessor.getUserByName(firstAdmin.getName());
        }
        return Option.option(firstAdminConfUser);
    }
}

