(function ($) {
    var STREAM_FILTER_TYPE_KEY = "com.atlassian.confluence.plugins.mobile.stream.filter.type";

    ConfluenceMobile.StreamFiltersView = Backbone.View.extend({
        el: ".container",

        activeStreamType: null,

        pageSize: null,

        initialize: function (options) {
            _.extend(this, options);
            this.activeStreamType = options.activeStreamType || ConfluenceMobile.storage.get(STREAM_FILTER_TYPE_KEY) || "popular";

        },

        streamViews: {},

        changeFilterView: function (streamType) {
            this.$("#dashboard-filters a").each(function () {
                $(this).toggleClass("selected", this.hash == "#dashboard/" + streamType);
            });

            var stream,
                streamView = this.streamViews[streamType],
                streamContainer = this.$('.stream-items-container'),
                that = this;

            streamContainer.empty();

            // If the stream already exists simply re-render it
            if (streamView) {
                streamView.setElement(streamContainer[0]);
                streamView.render();
                ConfluenceMobile.pageEventAggregator.trigger("post-render");

            } else {
                stream = new ConfluenceMobile.Stream(null, {streamType: streamType, contextPath: ConfluenceMobile.AppData.get("confluence-context-path") });
                var options = {
                    success: function () {
                        streamView.updateRoute();
                        that.streamViews[streamType] = streamView;
                        ConfluenceMobile.storage.set(STREAM_FILTER_TYPE_KEY, streamType);
                        ConfluenceMobile.pageEventAggregator.trigger("post-render");
                    }
                };

                if (this.pageSize) {
                    options.data = { pageSize: this.pageSize };
                    delete this.pageSize;
                }

                streamView = new ConfluenceMobile.StreamView({
                    collection: stream,
                    el: streamContainer[0]
                });

                stream.bind("error", this.streamErrorHandler, this);                
                stream.fetch(options);
            }

            // Flexbox doesn't like to trigger a repaint.
            ConfluenceMobile.triggerRepaint();

            this.activeStreamType = streamType;


        },

        changeFilter: function (e) {
            e.preventDefault();

            var streamType = e.target.hash.split("/").pop();
            this.changeFilterView(streamType);
        },

        render: function () {
            this.$el.html(Confluence.Templates.Mobile.StreamFilters.dashboardFilters());

            this.changeFilterView(this.activeStreamType);

            return this.$el;
        },
        
        streamErrorHandler: function (model, resp, options) {
            var that = this;
            var options = {
                message : AJS.I18n.getText("confluence.mobile.stream.loading.error"),        
                
                onRetry : function() {
                    that.changeFilterView(model.streamType);
                },
                
                onCancel : function() {
                    window.history.back();
                }
            };
            
            ConfluenceMobile.genericAjaxErrorHandler(resp, model, options);
        }

    });
})(Zepto);
