(function ($) {

    AJS.test.require("com.atlassian.confluence.plugins.confluence-mobile:app-resources");    

    var stringComparator = function(a,b) {
        return a.localeCompare(b);
    };
    
    module("test some basic binary search tree functionality");

    test("contains on an empty tree", function() {
        var tree = new ConfluenceMobile.Utils.BinarySearchTree(function(a,b) { /* dummy */ });
        
        ok(!tree.contains("apples"));
        equal(tree.size(), 0);
    });
    
    test("contains on a populated tree", function() {
       var tree = new ConfluenceMobile.Utils.BinarySearchTree(stringComparator);
       tree.add("grapefruit");
       
       ok(tree.contains("grapefruit"));
       ok(!tree.contains("apple"));
       equal(tree.size(), 1);
       
       tree.add("kiwi");
       ok(tree.contains("kiwi"));
       ok(tree.contains("grapefruit"));
       ok(!tree.contains("apple"));
       equal(tree.size(), 2);

       tree.add("banana");
       ok(tree.contains("banana"));
       ok(tree.contains("kiwi"));
       ok(tree.contains("grapefruit"));
       ok(!tree.contains("apple"));
       equal(tree.size(), 3);
       
       tree.add("blueberry");
       ok(tree.contains("blueberry"));
       ok(tree.contains("banana"));
       ok(tree.contains("kiwi"));
       ok(tree.contains("grapefruit"));
       ok(!tree.contains("apple"));
       ok(!tree.contains("orange"));
       equal(tree.size(), 4);
    });
    
    test("test toArray", function() {
        var tree = new ConfluenceMobile.Utils.BinarySearchTree(stringComparator);
        tree.add("tangerine");
        tree.add("banana");
        tree.add("grapefruit");
        tree.add("apple");
        
        var contents = tree.toArray();
        equal(contents.length, 4);
        equal(contents[0], "apple");
        equal(contents[1], "banana");
        equal(contents[2], "grapefruit");
        equal(contents[3], "tangerine");
    });
})(jQuery);