ConfluenceMobile.Comment = Backbone.Model.extend({

    defaults: function() {
        return {
            id: 0,
            html: "",
            ownerId: 0,
            parentId: 0,
            displayDate: AJS.I18n.getText("date.friendly.a.moment.ago"),
            commenter: ConfluenceMobile.AppData.getObject("current-user")
        };
    },

    url: function(isInlineComment) {
        var contextPath = ConfluenceMobile.AppData.get("confluence-context-path");
        var parentId = this.get("parentId");
        var ownerId = this.get("ownerId");

        if (isInlineComment) {
            return contextPath + "/rest/inlinecomments/1.0/comments/" +  parentId  + "/replies?containerId=" + ownerId;
        }

        var path = contextPath + "/rest/tinymce/1/content/" + ownerId;
        if (parentId) {
            path += "/comments/" + parentId;
        }

        return path + "/comment";
    },

    sync: function(method, model, options) {
        if (method == "update") {
            return this._saveNew(model, options);
        }
    },

    validate: function (attributes, options) {
        if (attributes["id"] < 0) {
            throw new Error("id is required and must be greater than or equal to 0");
        }

        if (attributes["ownerId"] < 0) {
            throw new Error("ownerId is required and must be greater than or equal to 0");
        }
    },

    initialize: function (attributes, options) {
        this.set("url", "#content/view/" + attributes.ownerId + "/" + attributes.id);
        this.set("uuid", uuid.v4());
    },

    /**
     * Save a new comment to the server.
     *
     * @param model
     * @param options
     * @returns the XHR object for the save request.
     */
    _saveNew : function(model, options) {
        var thiz = this;
        var currentUser = ConfluenceMobile.AppData.getObject("current-user");

        var isInlineComment = thiz.get("isInlineComment") === true;
        var commenter =  thiz.get("commenter");
        var data;
        if (isInlineComment) {
            data = JSON.stringify({
                authorDisplayName: commenter.fullName,
                authorUserName: commenter.userName,
                authorAvatarUrl: commenter.avatarUrl,
                body: this.get("html"),
                commentId: this.get("parentId")
            });
        } else {
            data = {
                "html": this.get("html"),
                "watch" : currentUser.userPreferences.watchOwnContent,
                "uuid" : this.get("uuid")
            }
        }

        var url = this.url(isInlineComment);
        var ajaxData = {
            type: "POST",
            url: url,
            contentType: isInlineComment ? "application/json" : "application/x-www-form-urlencoded; charset=UTF-8",
            data:data,
            dataType : "json",
            headers: {
                "X-Atlassian-Token" : "nocheck"
            },
            success : options.success,
            error : isInlineComment ? function(xhr, status, errorThrown) {
                if (xhr.status === 404) {
                    thiz.trigger("ic:disable-error");
                }
            }: options.error
        };

        if (options && options.captcha) {
            ajaxData.headers["X-Atlassian-Captcha"] = options.captcha;
        }

        return $.ajax(ajaxData);
    }
}, {

    /**
     * Returns a new comment model with the passed in comment as a parent.
     *
     * @param parent
     * @returns {ConfluenceMobile.Comment}
     */
    nestedCommentFromParent: function (parent) {
        var comment = new ConfluenceMobile.Comment({
            parentId: parent.get("id"),
            ownerId: parent.get("ownerId"),
            isInlineComment : parent.get("isInlineComment")
        });

        return comment;
    }
});