/* 
 * This object provides convenient access to the value of META tags in the document.
 * However, it also maintains a Javascript store of key and values over and above any document META tags so
 * is a convenient repository of data that is required application wide. 
 */
(function ($) {

    ConfluenceMobile.AppData = {
            
        objectCache: {},
        
        /**
         * If a key is found in the store this will be used in preference to the META tags of the page.
         */
        store: {},
            
        get: function (key) {
            var value = this.store[key];
            if (value) {
                return value;
            }
            
            var $meta = $("meta[name='" + key + "']");
            if ($meta.length == 0) {
                $meta = $("meta[name='ajs-" + key + "']");
            }

            if ($meta.length) {
                return $meta.attr("content");
            }
        },

        getBoolean: function (key) {
            return this.get(key) == "true";
        },

        /**
         * Retrieve a JSON encoded value and return it as an Object. The first time a key is requested it's deserialised form
         * is cached for subsequent requests.
         *
         * @param key the key of the JSON encoded Object
         * @param return the decoded Object or undefined if no JSON Object is found for the key
         */
        getObject: function(key) {
            if (!this.objectCache[key]) {
                var objStr = this.get(key);
                var obj = undefined;
                if (objStr && objStr.length) {
                    try {
                        obj = JSON.parse(objStr);
                    } catch (err) {
                        
                    }
                }
                
                this.objectCache[key] = obj;
            }
            
            return this.objectCache[key];
        },
        
        put: function(key, value)
        {
            this.store[key] = value;
        },

        /**
         * Returns the current logged in user or null if not logged in or anonymous.
         * @returns {*}
         */
        getUsername: function() {
            var currentUser = ConfluenceMobile.AppData.getObject("current-user");
            if (!currentUser || currentUser.anonymous) {
                return null;
            }

            return currentUser.userName;
        }
    };
})(Zepto);