(function ($) {
    ConfluenceMobile.StreamView = Backbone.View.extend({
        events: {
            "click .more-button button" : "loadMore"
        },
        initialize: function() {
            this.collection.bind("add", this.add, this);
            this.collection.bind("reset", this.render, this);
            this.notification = new ConfluenceMobile.Notification(this.el);
            this.notification.showLoading();
        },
        add: function(item) {
            this.$("ol#stream-items").append(new ConfluenceMobile.StreamItemView({model: item}).render().el);
        },
        showSpinner: function() {
            this.$(".more-button").addClass("loading");
        },
        hideSpinner: function() {
            this.$(".more-button").removeClass("loading");
        },
        render: function() {
            this.$el.html(Confluence.Templates.Mobile.Stream.stream());

            this.el && (this.notification = new ConfluenceMobile.Notification(this.el));

            this.notification.hide();

            if (this.collection.length) {
                this.$("ol#stream-items").empty();
                var that = this;
                this.collection.each(function(item) {
                    that.add(item);
                });

                if (this.collection.nextPageOffset) {
                    this.$(".more-button").show();
                }

            } else {
                this.notification.showMessage(AJS.I18n.getText("confluence.mobile.stream.recent.no.content"));
            }

            return this;
        },
        update: function() {
            this.notification.toggle(AJS.I18n.getText("confluence.mobile.stream.recent.no.content"), !this.collection.length);
            this.loading.hide();
        },
        updateRoute: function() {
            var collectionLength = this.collection.length,
                route = "dashboard/" + this.collection.streamType;

            if (collectionLength) {
                route += "/" + collectionLength;
            }
            ConfluenceMobile.router.navigate(route, {replace: true});

        },
        removeMoreButton: function () {
            this.$(".more-button").remove();
        },
        loadMore: function(e) {
            this.showSpinner();
            var that = this;

            var data = {};
            if (this.collection.nextPageOffset) {
                data.nextPageOffset = this.collection.nextPageOffset;
            }
            if (this.collection.token) {
                data.token = this.collection.token;
            }

            this.collection.fetch({
                add: true,
                data: data,
                success: function (collection) {
                    if (!collection.nextPageOffset) {
                        that.removeMoreButton();
                    }
                    that.hideSpinner();
                    that.updateRoute();
                },
                error: function (model, response, options) {
                    var errorMessage = AJS.I18n.getText("confluence.mobile.stream.loading.error");

                    try
                    {
                        var parseResult = JSON.parse(response.responseText);
                        if (parseResult && parseResult.message) {
                            errorMessage = parseResult.message;
                        }
                    }
                    catch (e)
                    {
                        AJS.log("Error parsing response", e);
                    }

                    $.extend(options, {
                        message : errorMessage,

                        onRetry : function () {
                            window.location.reload();
                        },

                        onCancel : function () {
                            that.hideSpinner();
                            that.removeMoreButton();
                        },

                        retryButtonLabelText : AJS.I18n.getText("confluence.mobile.refresh")
                    });

                    ConfluenceMobile.genericAjaxErrorHandler(response, model, options);
                }
            });


            ConfluenceMobile.Analytics.trackEvent("stream", "click-load-more");
        }
    });
})($);
