define('confluence-mobile/watch-model',
    [
        'backbone',
        'jquery',
        'window'
    ],
    function (Backbone, $, window) {
        return Backbone.Model.extend({
            toggleWatch: function () {
                var contextPath = window.ConfluenceMobile.AppData.get('confluence-context-path');
                var watching = this.get('watching');
                var url = contextPath + '/users/' + (watching ? 'remove' : 'add') + 'pagenotificationajax.action';
                var data = {
                    pageId: this.get('contentId'),
                };

                $.ajax({
                    url: url,
                    type: 'POST',
                    dataType: 'json',
                    headers: {
                        'X-Atlassian-Token': 'no-check'
                    },
                    data: data
                });

                this.set('watching', !watching);
            }
        });
    });
