(function ($) {

    AJS.test.require(["com.atlassian.confluence.plugins.confluence-mobile:app-frame"], function () {
        var module = QUnit.module;
        var test = QUnit.test;
        module("test the ContentLoader and its dependency tracking", function () {
            test("Empty page loader", function(assert) {
                var contentLoader = new ConfluenceMobile.Utils._ContentLoader(null, "a/b/c");
                assert.equal(contentLoader.resourceCount(), 0);
                assert.equal(contentLoader.contextCount(), 0);
            });

            test("single resource per element", function(assert) {
                var $elements = $("<LINK data-atlassian-webresource-contents=\"a.b.c:d[1.1]\"><LINK data-atlassian-webresource-contents=\"a.b.c:e[1.1]\"><LINK data-atlassian-webresource-contents=\"x.y.z:z[3]\"><LINK data-atlassian-webresource-contents=\"x.y.z:z[3]\">");
                var contentLoader = new ConfluenceMobile.Utils._ContentLoader($elements, "a/b/c");

                assert.equal(contentLoader.resourceCount(), 3);
                assert.equal(contentLoader.contextCount(), 0);

                assert.ok(contentLoader.hasResource("x.y.z:z"));
                assert.ok(contentLoader.hasResource("a.b.c:d"));
                assert.ok(contentLoader.hasResource("a.b.c:e"));

                assert.ok(!contentLoader.hasResource("d.e.f:ghi"));

                assert.ok(!contentLoader.hasContext("any"));

            });

            test("multiple resource per element with contexts", function(assert) {
                var $elements = $("<LINK data-atlassian-webresource-contents=\"a.b.c:d[1.1],f.g.h.i:jkl[3.2],a.b.c:e[1.1]\" data-atlassian-webresource-contexts=\"contextA,contextZ\"><LINK data-atlassian-webresource-contents=\"m.n.o.p.q:r[3],a.b.c:e[1.1]\" data-atlassian-webresource-contexts=\"contextA,contextB,contextC\">");
                var contentLoader = new ConfluenceMobile.Utils._ContentLoader($elements, "a/b/c");

                assert.equal(contentLoader.resourceCount(), 4);
                assert.equal(contentLoader.contextCount(), 4);

                assert.ok(contentLoader.hasResource("a.b.c:d"));
                assert.ok(contentLoader.hasResource("f.g.h.i:jkl"));
                assert.ok(contentLoader.hasResource("a.b.c:e"));
                assert.ok(contentLoader.hasResource("m.n.o.p.q:r"));

                assert.ok(contentLoader.hasContext("contextA"));
                assert.ok(contentLoader.hasContext("contextB"));
                assert.ok(contentLoader.hasContext("contextC"));
                assert.ok(contentLoader.hasContext("contextZ"));
            });

            test("add additonal resources and contexts", function(assert) {
                var $elements = $("<LINK data-atlassian-webresource-contents=\"a.b.c:e[1.1]\" data-atlassian-webresource-contexts=\"contextA\">");
                var contentLoader = new ConfluenceMobile.Utils._ContentLoader($elements, "a/b/c");

                assert.equal(contentLoader.resourceCount(), 1);
                assert.equal(contentLoader.contextCount(), 1);

                contentLoader.addResource("x.y.z:zed","2.5");
                contentLoader.addContext("contextZ");

                assert.equal(contentLoader.resourceCount(), 2);
                assert.equal(contentLoader.contextCount(), 2);

                assert.ok(contentLoader.hasResource("a.b.c:e"));
                assert.ok(contentLoader.hasResource("x.y.z:zed"));

                assert.ok(contentLoader.hasContext("contextA"));
                assert.ok(contentLoader.hasContext("contextZ"));
            });
        });
    });
})(jQuery);