/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.search;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.searchfilter.InSpaceSearchFilter;
import com.atlassian.confluence.search.v2.searchfilter.SiteSearchPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public final class CardSearchBuilder {
    private int hours;
    private Set<String> spaceKeys;

    public ISearch buildSearch(PageRequest pageRequest) {
        return new ContentSearch(this.buildSearchQuery(), (SearchSort)ModifiedSort.DESCENDING, this.buildSearchFilter(), pageRequest.getStart(), pageRequest.getLimit());
    }

    public CardSearchBuilder withSpaceKeys(Set<String> spaceKeys) {
        this.spaceKeys = spaceKeys;
        return this;
    }

    public CardSearchBuilder since(int hours) {
        this.hours = hours;
        return this;
    }

    private SearchFilter buildSearchFilter() {
        SiteSearchPermissionsSearchFilter filter = SiteSearchPermissionsSearchFilter.getInstance();
        if (this.spaceKeys != null) {
            filter = filter.and((SearchFilter)new InSpaceSearchFilter(this.spaceKeys));
        }
        return filter;
    }

    private SearchQuery buildSearchQuery() {
        HashSet searchTerms = Sets.newHashSet();
        searchTerms.add(new ContentTypeQuery((Collection)Lists.newArrayList((Object[])new ContentTypeEnum[]{ContentTypeEnum.PAGE, ContentTypeEnum.BLOG, ContentTypeEnum.COMMENT})));
        if (this.hours > 0) {
            searchTerms.add(this.buildDateRangeQuery(this.hours));
        }
        return BooleanQuery.composeAndQuery((Set)searchTerms);
    }

    private DateRangeQuery buildDateRangeQuery(int hours) {
        Date endDate = Calendar.getInstance().getTime();
        Calendar startDate = Calendar.getInstance();
        startDate.add(10, -hours);
        return new DateRangeQuery(startDate.getTime(), endDate, true, true, DateRangeQuery.DateRangeQueryType.MODIFIED);
    }
}

