/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.service.impl;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.plugins.mobile.dto.NotificationDto;
import com.atlassian.confluence.plugins.mobile.service.MobileNotificationService;
import com.atlassian.confluence.plugins.mobile.service.converter.MobileNotificationConverter;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.mywork.model.NotificationFilter;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MobileNotificationServiceImpl
implements MobileNotificationService {
    private final LocalNotificationService notificationService;
    private final MobileNotificationConverter notificationConverter;

    @Autowired
    public MobileNotificationServiceImpl(@ComponentImport LocalNotificationService notificationService, MobileNotificationConverter notificationConverter) {
        this.notificationService = notificationService;
        this.notificationConverter = notificationConverter;
    }

    @Override
    public PageResponse<NotificationDto> getNotifications(NotificationFilter filter, PageRequest pageRequest) {
        List notifications = this.notificationService.findAllWithCurrentUser(filter, pageRequest.getStart(), pageRequest.getLimit());
        boolean hasMore = notifications.size() == pageRequest.getLimit();
        return RestList.newRestList((PageRequest)pageRequest).results(this.notificationConverter.to(notifications), hasMore).build();
    }

    @Override
    public void readNotifications(NotificationFilter filter) {
        this.notificationService.setReadWithCurrentUser(filter);
    }

    @Override
    public void deleteNotification(NotificationFilter filter) {
        this.notificationService.deleteWithCurrentUser(filter);
    }
}

