package com.atlassian.confluence.plugins.mentions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.user.ConfluenceUser;

import java.util.Set;

public interface NotificationService {
    /**
     * send mention notifications to target users, permission filters are applied
     *
     * @param mentionedUsers target users
     * @param author         mention author
     * @param content        content with mentions added
     * @since 2.0.0
     */
    void sendMentions(final Set<ConfluenceUser> mentionedUsers,
                      final ConfluenceUser author,
                      final ContentEntityObject content);

    /**
     * @param mentionedUsers
     * @param author
     * @param contentEntityObject
     * @deprecated since 2.0.0 use {@link #sendMentions(Set, ConfluenceUser, ContentEntityObject)} instead.
     */
    @Deprecated
    void sendMentionEmails(final Set<ConfluenceUser> mentionedUsers,
                           final ConfluenceUser author,
                           final ContentEntityObject contentEntityObject);

    /**
     * @param userNames mentioned users username list
     * @param content   content with mentions added
     * @deprecated since 2.0.0 use {@link #sendMentions(Set, ConfluenceUser, ContentEntityObject)} instead.
     */
    @Deprecated
    void sendMentionsEmail(final Iterable<String> userNames, final ContentEntityObject content);
}