/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail.services;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.masterdetail.analytics.DetailsSummaryMacroMetricsEvent;
import com.atlassian.confluence.extra.masterdetail.services.DefaultPagePropertiesService;
import com.atlassian.confluence.extra.masterdetail.services.DetailsMacroBodyHandler;
import com.atlassian.confluence.plugins.pageproperties.api.model.PageProperty;
import com.atlassian.confluence.xhtml.api.MacroDefinitionHandler;
import com.atlassian.confluence.xhtml.api.MacroDefinitionMarshallingStrategy;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.renderer.RenderContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagePropertiesExtractor {
    private static final Logger log = LoggerFactory.getLogger(DefaultPagePropertiesService.class);
    private final XhtmlContent xhtmlContent;

    public PagePropertiesExtractor(XhtmlContent xhtmlContent) {
        this.xhtmlContent = xhtmlContent;
    }

    public ImmutableMap<String, ImmutableList<ImmutableMap<String, PageProperty>>> extractProperties(ContentEntityObject entity, DetailsSummaryMacroMetricsEvent.Builder metrics) {
        DefaultConversionContext subContext = new DefaultConversionContext((RenderContext)entity.toPageContext());
        DetailsMacroBodyHandler macroBodyHandler = new DetailsMacroBodyHandler(metrics);
        try {
            metrics.entityBodyFetchStart();
            String entityBody = entity.getBodyAsString();
            metrics.entityBodyFetchFinish(StringUtils.defaultString((String)entityBody).length());
            this.xhtmlContent.handleMacroDefinitions(entityBody, (ConversionContext)subContext, (MacroDefinitionHandler)macroBodyHandler, MacroDefinitionMarshallingStrategy.MARSHALL_MACRO);
        }
        catch (XhtmlException e) {
            log.error("Cannot extract page properties from content with id: " + entity.getIdAsString(), (Throwable)e);
        }
        return macroBodyHandler.getDetails();
    }
}

