/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.masterdetail.analytics.DetailsSummaryMacroMetricsEvent;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Qualifier;

public class ContentRetriever {
    private final CQLSearchService searchService;
    private final ContentEntityManager contentEntityManager;
    private final I18nResolver i18nResolver;

    public ContentRetriever(CQLSearchService searchService, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, I18nResolver i18nResolver) {
        this.searchService = searchService;
        this.contentEntityManager = contentEntityManager;
        this.i18nResolver = i18nResolver;
    }

    public List<ContentEntityObject> getContentWithMetaData(@Nonnull String cql, boolean reverseSort, SearchContext searchContext, DetailsSummaryMacroMetricsEvent.Builder metrics) throws MacroExecutionException {
        int limit = 1000;
        SimplePageRequest initialPageRequest = new SimplePageRequest(0, 1000);
        String fullCql = "(" + cql + ") and macro = details" + this.buildOrderByClause(reverseSort);
        metrics.contentSearchStart();
        ArrayList results = Lists.newArrayList();
        try {
            PageResponse contents = this.searchService.searchContent(fullCql, searchContext, (PageRequest)initialPageRequest, new Expansion[0]);
            results.addAll(contents.getResults());
            while (contents.hasMore()) {
                SimplePageRequest nextBatchPageRequest = new SimplePageRequest(results.size(), 1000);
                contents = this.searchService.searchContent(cql, searchContext, (PageRequest)nextBatchPageRequest, new Expansion[0]);
                results.addAll(contents.getResults());
            }
        }
        catch (ServiceException e) {
            String msg = this.i18nResolver.getText("detailssummary.error.searchservice.exception", new Serializable[]{fullCql, e.getMessage()});
            throw new MacroExecutionException(msg, (Throwable)e);
        }
        metrics.contentSearchFinish();
        metrics.labelledContentCount(results.size());
        return this.asContentEntityObjects(results);
    }

    private String buildOrderByClause(boolean reverseSort) {
        String order = " order by lastModified";
        if (!reverseSort) {
            order = order + " desc";
        }
        return order;
    }

    private List<ContentEntityObject> asContentEntityObjects(List<Content> results) {
        ArrayList ceos = Lists.newArrayList();
        for (Content result : results) {
            ContentEntityObject ceo = this.contentEntityManager.getById(result.getId().asLong());
            if (ceo == null) continue;
            ceos.add(ceo);
        }
        return ceos;
    }
}

