AJS.toInit(function($) {
    var thread = $("ul.menuList"),
        toggleSummaries = function(e) {
            var button = $(e.target);
            var summariesHidden = button.data("summaries-hidden");

            if (summariesHidden) {
                thread.find(".excerpt").show();
                button.val(AJS.I18n.getText("mail.thread.summaries.hide"));
            }
            else {
                thread.find(".excerpt").hide();
                button.val(AJS.I18n.getText("mail.thread.summaries.show"));
            }

            button.data("summaries-hidden", !summariesHidden);
        },
        openAll = function() {
            thread.find("li.expand > .actuator").click();
        },
        closeAll = function() {
            thread.find("li.collapse > .actuator").click();
        };

    // Bind buttons
    $("#summaryToggle").on("click", toggleSummaries);
    $("#mailThreadOpenAll").on("click", openAll);
    $("#mailThreadCloseAll").on("click", closeAll);

    // Initialise the tree actuators
    thread.on("click", "li .actuator", function(e) {
        e.preventDefault();
        var actuator = $(e.target);
        var node = actuator.parent("li");
        if (!node.hasClass("expand") && !node.hasClass("collapse"))
            return;
        node.toggleClass("expand").toggleClass("collapse");
    });

    // Scroll the page to the currently selected node
    var openPageSpan = $("#openPage");
    if (openPageSpan.length != 0)
        window.scrollTo(0, openPageSpan.offset().top - 150);
});