/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.mail.archive.actions;

import com.atlassian.confluence.mail.archive.AbstractMailAccount;
import com.atlassian.confluence.mail.archive.ImapMailAccount;
import com.atlassian.confluence.mail.archive.MailAccount;
import com.atlassian.confluence.mail.archive.MailAccountManager;
import com.atlassian.confluence.mail.archive.MailPollResult;
import com.atlassian.confluence.mail.archive.PopMailAccount;
import com.atlassian.confluence.mail.archive.actions.MailActionBreadcrumb;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.breadcrumbs.Breadcrumb;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbAware;
import com.atlassian.confluence.util.breadcrumbs.BreadcrumbGenerator;
import com.opensymphony.xwork.Action;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractMailAccountAction
extends AbstractSpaceAction
implements BreadcrumbAware {
    protected MailAccountManager mailAccountManager;
    protected String name;
    protected String description;
    protected String hostname;
    protected String protocol;
    protected String username;
    protected String password;
    protected int port;
    protected boolean secure;
    protected String confirm;
    protected String testConnection;
    protected MailPollResult pollResult;
    private BreadcrumbGenerator breadcrumbGenerator;

    public void validate() {
        super.validate();
        if (StringUtils.isBlank((String)this.getName())) {
            this.addFieldError("name", this.getText("error.account.name.reqd"));
        }
        if (StringUtils.isBlank((String)this.getHostname())) {
            this.addFieldError("hostname", this.getText("error.hostname.reqd"));
        }
        if (StringUtils.isBlank((String)this.getUsername())) {
            this.addFieldError("username", this.getText("error.username.reqd"));
        }
        if (StringUtils.isBlank((String)this.getPassword())) {
            this.addFieldError("password", this.getText("error.password.reqd"));
        }
        if (this.getSpace().isPersonal()) {
            this.addActionError(this.getText("error.personal.space"));
        }
    }

    protected List<String> getPermissionTypes() {
        List permissions = super.getPermissionTypes();
        this.addPermissionTypeTo("SETSPACEPERMISSIONS", permissions);
        return permissions;
    }

    public void setMailAccountManager(MailAccountManager mailAccountManager) {
        this.mailAccountManager = mailAccountManager;
    }

    public abstract boolean isEditAction();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getTestConnection() {
        return this.testConnection;
    }

    public void setTestConnection(String testConnection) {
        this.testConnection = testConnection;
    }

    public MailPollResult getPollResult() {
        return this.pollResult;
    }

    public void setPollResult(MailPollResult pollResult) {
        this.pollResult = pollResult;
    }

    public void setBreadcrumbGenerator(BreadcrumbGenerator breadcrumbGenerator) {
        this.breadcrumbGenerator = breadcrumbGenerator;
    }

    protected MailAccount createMailAccountFromFormData() {
        AbstractMailAccount mailAccount;
        if (this.isProtocol("pop3")) {
            mailAccount = new PopMailAccount(0, this.name, this.description, this.hostname, this.username, this.password, this.port, this.isProtocolSecure());
        } else if (this.isProtocol("imap")) {
            mailAccount = new ImapMailAccount(0, this.name, this.description, this.hostname, this.username, this.password, this.port, this.isProtocolSecure());
        } else {
            throw new UnsupportedOperationException("Protocol: " + this.getProtocol() + " not supported.");
        }
        return mailAccount;
    }

    private boolean isProtocolSecure() {
        return this.getProtocol().endsWith("s");
    }

    private boolean isProtocol(String protocol) {
        return this.getProtocol().indexOf(protocol) != -1;
    }

    public Breadcrumb getBreadcrumb() {
        return new MailActionBreadcrumb((Action)this, this.getSpace(), null, this.breadcrumbGenerator.getSpaceAdminBreadcrumb((Action)this, this.getSpace()));
    }
}

