define('confluence/cjc/issue/collection', [
    'backbone',
    'underscore',
    'confluence/cjc/issue/model'
],
function(
    Backbone,
    _,
    IssueModel
) {
    'use strict';

    var IssueCollection = Backbone.Collection.extend({
        model: IssueModel,

        validate: function() {
            var errors = [];

            this.each(function(issue) {
                errors = errors.concat(issue.validate());
            });

            return errors;
        },

        getFieldNameAndContentAsArray: function() {
            var arrayFieldNameAndContent = this.map(function(issueModel) {
                var fields = issueModel.get('fields');

                var newObj = {};
                var hasError = false;


                fields.each(function(field) {
                    var fieldName = field.get('name');
                    var content = field.get('content');

                    if (content instanceof Error) {
                        hasError = true;
                    } else if (content && field.get('isSupport')) {
                        newObj[fieldName] = content;
                    }
                });

                if (!hasError) {
                    return newObj;
                }
            });

            // remove undefined value
            arrayFieldNameAndContent = _.filter(arrayFieldNameAndContent, function(obj) {
                return !!obj;
            });

            return arrayFieldNameAndContent;
        }
    });

    return IssueCollection;
});



