define('confluence/cjc/issue-field/model', [
    'underscore',
    'ajs',
    'backbone',
    'confluence/cjc/error/error-type'
],
function(
    _,
    AJS,
    Backbone,
    ErrorType
) {
    'use strict';

    var IssueFieldModel = Backbone.Model.extend({

        defaults: {
            name: '', // field name, ex: summary, description, duedate...
            type: 'string', // type of field, can be: date,string
            index: 0, // index column in table content view
            required: false,
            label: '', // friendly label
            content: '',
            // to distinguish default supported fields (summary, description, duedate) with others
            isSupport: true
        },

        initialize: function(options) {
            this.customValidate = options.customValidate;

            this.on('change:index', function() {
               if (isNaN(this.get('index'))) {
                   this.attributes.index = -1;
               }
            });
        },

        setNextIndexColumn: function(currentIndexColumn, totalColumn) {
            var nextIndexColumn = 0;

            if (totalColumn > 0) {
                nextIndexColumn = (currentIndexColumn + 1) % totalColumn;
            } else {
                nextIndexColumn = currentIndexColumn;
            }
            this.set('index', nextIndexColumn);
        },

        validate: function() {
            var error = this._checkRequired();

            if (!error && this.customValidate) {
                error = this.customValidate.apply(this, arguments);
            }

            return error;
        },

        _checkRequired: function() {
            var error;

            if (this.get('required')) {
                var content = this.get('content');

                if (content === undefined || content === null || content === '') {
                    error = {
                        errorMessageContent: AJS.I18n.getText('createjiracontent.dialog.create.issue.error.required.field', this.get('label')),
                        type: ErrorType.ERROR_INVALID_SUBMIT_DATA_ID
                    };
                }
            }

            return error;
        }
    });

    return IssueFieldModel;
});



