define('confluence/cjc/create-issue-form/create-single-issue-view', [
    'confluence/cjc/issue/model',
    'confluence/cjc/issue/collection',
    'confluence/cjc/create-issue-form/create-issue-form-view-abstract'
],
function(
    IssueModel,
    IssueCollection,
    CreateIssueFormViewAbstract
) {
    'use strict';

    /**
     * Creating Single Issue View
     */
    var CreateSingleIssueView = CreateIssueFormViewAbstract.extend({

        initialize: function(options) {
            CreateIssueFormViewAbstract.prototype.initialize.apply(this, arguments);
        },

        render: function() {
            CreateIssueFormViewAbstract.prototype.render.apply(this, arguments);

            AJS.debug('CreateSingleIssueView().render();');
        },

        /**
         * Scan creating single issue form and create IssueCollection
         * @returns {IssueCollection}
         */
        getIssueCollection: function() {
            var issueCollection = new IssueCollection();
            var issue = new IssueModel();

            var summaryField = this.getFieldObjectFromDOM('summary', this.$('#issue-summary').parent());
            issue.get('fields').add(summaryField);

            var descField = this.getFieldObjectFromDOM('description', this.$('#issue-description').parent());
            issue.get('fields').add(descField);

            this.extractExtraFields(issue);

            issueCollection.add(issue);
            return issueCollection;
        },

        /**
         * When switch from Create Multiple Issues to Create Single Issue form, we need to refresh the UI.
         */
        refresh: function() {
            var $dialogHeader = this.$('#create-issues-dialog-header');
            $dialogHeader.text(AJS.I18n.getText('createjiracontent.dialog.form.header.title'));

            this.toggleLinkSwitchSingleMultipleForm(false);

            this.$('#create-from-table, #create-from-table-field').hide();
            this.$('#create-from-text').show();
        },

        submitFormWhenValid: function() {
            this.formObjectView.errorMessageView.reset();
            var issueCollection = this.getIssueCollection();

            var errors = issueCollection.validate();
            if (errors.length) {
                this.renderErrorMessages(errors);
                return;
            }

            var issues = issueCollection.getFieldNameAndContentAsArray();
            this.formObjectView.createIssues(issues);
        },

        submitFormWhenInvalid: function(errors) {
            this.renderErrorMessages(errors);
        }

    });

    return CreateSingleIssueView;
});
