define('confluence/cjc/common/select2-helper', [
    'jquery',
    'ajs'
],
function(
    $,
    AJS
) {
    'use strict';

    /**
     * This class is migrated from a part of `.../js/jira-form-helper.js`.
     * We want to kill `.../js/jira-form-helper.js` and first step is to split it up as many modules as possible.
     */
    return {
        DEFAULT_OPTION_VALUE: '-1',
        DEFAULT_LOADING_VALUE: 'loading',
        DEFAULT_OPTION_TEXT: AJS.I18n.getText('createjiracontent.dialog.form.select.default.text'),
        LOADING_OPTION_TEXT: AJS.I18n.getText('createjiracontent.dialog.form.select.loading.text'),

        toggleEnable: function($el, isEnabled) {
            $el.auiSelect2('enable', isEnabled);
        },

        tooltipFormat: function(result) {
            return window.Confluence.CreateJiraContent.selectOption({optionValue: result.text});
        },

        clearAndAddDefaultOption: function($el, customizeOptionText) {
            var optionContent = window.aui.form.optionOrOptgroup({
                value: this.DEFAULT_OPTION_VALUE,
                text: customizeOptionText ? customizeOptionText : this.DEFAULT_OPTION_TEXT
            });

            $el.html(optionContent);
            $el.auiSelect2('val', this.DEFAULT_OPTION_VALUE);
        },

        showLoadingAndDisabled: function($el) {
            this.toggleEnable($el, false);

            var optionContent = aui.form.optionOrOptgroup({
                value: this.DEFAULT_OPTION_VALUE,
                text: this.LOADING_OPTION_TEXT
            });

            $el.html(optionContent);
            $el.auiSelect2('val', this.LOADING_OPTION_TEXT);
        },

        displayErrorLoading: function($el) {
            this.clearAndAddDefaultOption($el);
        },

        createSelect2WithTooltip: function($el, config) {
            var defaultConfig = {
                escapeMarkup: function(markup) {
                    // Keep this for now.
                    // Although automatic escaping of HTML in Confluence Select2 library is now disabled and this code currently does not do anything,
                    // it will be needed if the select2 library is updated and re-enabled the autoescaping in the future.
                    return markup;
                },
                formatResult: this.tooltipFormat.bind(this),
                formatSelection: this.tooltipFormat.bind(this)
            };

            $el.auiSelect2($.extend(defaultConfig, config));
        },

        clearAndDisabled: function($el, defaultOptionText) {
            this.toggleEnable($el, false);
            this.clearAndAddDefaultOption($el, defaultOptionText || this.DEFAULT_OPTION_TEXT);
            // make selectBox not be focused
            $el.prev().find('a').removeAttr('tabindex');
        },

        enableSelectBox: function($el) {
            $el.auiSelect2('enable', true);
            $el.prev().find('a').attr('tabindex', '0');
        },

        /**
         * Check Select control if it has an option with special value or not
         * @param jQueryObject $select
         * @param String/Integer value
         * @returns True/False
         */
        isOptionAvailable: function($select, value) {
            return ($select.find('option[value="' + value + '"]').length);
        },

        /**
         * Set selected value into a Select2 control
         * @param jQueryObject $select
         * @param String/Integer value
         * @returns {boolean}
         */
        setSelectFieldValue: function($select, value) {
            if (this.isOptionAvailable($select, value)) {
                $select.auiSelect2('val', value);
                return true;
            }

            return false;
        },
    };
});
