(function($){
    "use strict";

    AJS.$(function ($) {
        $("#qunit-fixture").append("<div id='container-test'>");
    });

    AJS.test.require("com.atlassian.confluence.plugins.confluence-inline-tasks:sortable-table-server-side", AJS.$.noop);

    var $taskContainer,
        $table,
        htmlTable = '<table class="aui tasks-report">'
            + '<thead>'
                + '<tr class="tablesorter-headerRow">'
                    + '<th class="header-description aui-table-column-unsortable" data-column-name="description">Description</th>'
                    + '<th class="header-duedate" data-column-name="duedate">Due date</th>'
                    + '<th class="header-assignee" data-column-name="assignee">Assignee</th>'
                    + '<th class="header-location" data-column-name="location">Task appears on</th>'
                + '</tr>'
            + '</thead>'
                + '<tbody>' //should have at least 1 row so that TableSorter will fire sortEnd event
                + '<tr data-task-id="2">'
                    + '<td>col1</td>'
                    + '<td>col2</td>'
                    + '<td>col3</td>'
                    + '<td>col4</td>'
                + '</tr>'
                + '</tbody>'
            + '</table>';

    var options = {
            setup: function () {
                $taskContainer = $('#container-test');
                $taskContainer.html(htmlTable);
                $table = $taskContainer.find("table.aui");
            },
            teardown: function() {
                $table.trigger("destroy");
                $taskContainer.empty();
            }
        };

    module("test 'reverseSort' option", options);

    test("reverseSort=false, header column should have a expected class", function() {
        $table.tablesorterServerOnly({
            reverseSort: false,
            sortColumn: "location"
        });

        //assert
        ok($table.find("th.header-location").hasClass("tablesorter-headerAsc"));
    });

    test("reverseSort=true, header column should have a expected class", function() {
        $table.tablesorterServerOnly({
            reverseSort: true,
            sortColumn: "assignee"
        });

        //assert
        ok($table.find("th.header-assignee").hasClass("tablesorter-headerDesc"));
    });

    test("reverseSort=false, clicking header sorting column should change to descending class", function() {
        var sortColumn = "assignee";
        var sortDirection = 0;//ascending

        $table.tablesorterServerOnly({
            reverseSort: sortDirection,
            sortColumn: sortColumn
        });

        //action
        $table.trigger("simulateClickHeader.sortServerOnly", [sortColumn, !sortDirection]);
        $table.trigger("refreshHeader.sortServerOnly");

        //assert
        ok($table.find("th.header-assignee").hasClass("tablesorter-headerDesc"));
    });

    test("reverseSort=true, clicking header sorting column should change to ascending class", function() {
        var sortColumn = "location";
        var sortDirection = 1; //ascending

        $table.tablesorterServerOnly({
            reverseSort: sortDirection,
            sortColumn: sortColumn
        });

        //action
        $table.trigger("simulateClickHeader.sortServerOnly", [sortColumn, !sortDirection]);
        $table.trigger("refreshHeader.sortServerOnly");

        //assert
        ok($table.find("th.header-location").hasClass("tablesorter-headerAsc"));
    });

    module("test events", options);

    test("'onInit' should be called", function() {
        expect(2);

        $table.tablesorterServerOnly({
            onInit: function(){
                //assert
                ok(this === $table[0], "this is table");
                ok(true, "the callback must be called");
            }
        });
    });

}(AJS.$));