/**
 * Register the inline tasks list control.
 */
define('confluence-inline-tasks/tinymce/inline-tasks-rte', [
    'jquery',
    'confluence/legacy',
    'confluence/meta'
],
function(
    $,
    Confluence,
    Meta
){
    'use strict';

    function createUlForInlineTasks(node) {
        var $lis = $(node).find('li[data-inline-task-id]');
        $lis.each(function(){
            var $li = $(this);
            var $parent = $li.parent();

            if (!$parent.is('ul')) {
                $parent.wrapInner('<ul class="inline-task-list"/>');
            } else if (!$parent.hasClass('inline-task-list')) {
                $parent.addClass('inline-task-list');
            }
        });
    }

    function filterInlineTasks(node) {
        createUlForInlineTasks(node);
        var contentType;
        // optional dependency confluence-editor/editor/page-editor
        // TODO use require.defined, when almond supports that
        if (Confluence.Editor !== undefined && Confluence.Editor.getContentType !== undefined) {
            contentType = Confluence.Editor.getContentType();
        } else {
            contentType = Meta.get('content-type');
        }

        var $uls = $(node).find('ul.inline-task-list');
        var $lis = $uls.find("> li");

        if (contentType === 'comment') {
            // There should be no InlineTasks in comments.
            $lis.removeClass('checked').removeAttr("data-inline-task-id");
            $uls.removeClass('inline-task-list');
        } else {
            // Add a class on pasted inline tasks
            $lis.attr("data-pasted-task", "true");
        }
    }

    return {
        filterInlineTasks: filterInlineTasks
    };
});

require('confluence/module-exporter').safeRequire('confluence-inline-tasks/tinymce/inline-tasks-rte', function(InlineTasksRte) {
    var $ = require('jquery');
    $(document).bind('postPaste', function(e, pl, o) {
        InlineTasksRte.filterInlineTasks(o.node);
    });
});