/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.upgradetask;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class StorageToAoMigrationLatch
extends CountDownLatch {
    private final AtomicInteger taskExtractorsRemaining;
    private final AtomicInteger taskInsertersRemaining;
    private final AtomicBoolean pageFinderActive;

    public StorageToAoMigrationLatch(int numTaskExtractorThreads, int numTaskInserterThreads) {
        super(1 + numTaskExtractorThreads + numTaskInserterThreads);
        this.taskExtractorsRemaining = new AtomicInteger(numTaskExtractorThreads);
        this.taskInsertersRemaining = new AtomicInteger(numTaskInserterThreads);
        this.pageFinderActive = new AtomicBoolean(true);
    }

    @Override
    public void countDown() {
        throw new UnsupportedOperationException("Use a different countDown method to specify exactly what kind of thread is terminating.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageFinderDone() {
        AtomicBoolean atomicBoolean = this.pageFinderActive;
        synchronized (atomicBoolean) {
            super.countDown();
            this.pageFinderActive.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskExtractorDone() {
        AtomicInteger atomicInteger = this.taskExtractorsRemaining;
        synchronized (atomicInteger) {
            super.countDown();
            this.taskExtractorsRemaining.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void taskInserterDone() {
        AtomicInteger atomicInteger = this.taskInsertersRemaining;
        synchronized (atomicInteger) {
            super.countDown();
            this.taskInsertersRemaining.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPageFindComplete() {
        AtomicBoolean atomicBoolean = this.pageFinderActive;
        synchronized (atomicBoolean) {
            return !this.pageFinderActive.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskExtractionComplete() {
        AtomicInteger atomicInteger = this.taskExtractorsRemaining;
        synchronized (atomicInteger) {
            return this.taskExtractorsRemaining.get() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskInsertionComplete() {
        AtomicInteger atomicInteger = this.taskInsertersRemaining;
        synchronized (atomicInteger) {
            return this.taskInsertersRemaining.get() == 0;
        }
    }
}

