define('confluence/ic/view/likes',
    [
        'backbone',
        'ajs',
        'confluence/ic/model/likes',
        'confluence/ic/likes/likes-manager'
    ],
    function (
        Backbone,
        AJS,
        Likes,
        LikesManager
    ) {
        "use strict";

        var LikesView = Backbone.View.extend({
            className: "ic-likes",

            events: {
                "click .ic-like-button": "toggleLike",
                "click .ic-likes-count": function(e) {
                    Confluence.Likes.showLikeUsers && Confluence.Likes.showLikeUsers.apply(e.currentTarget, [e]);
                }
            },

            initialize: function (options) {
                this.collection = new Likes(null, { contentId: options.contentId });
                this.listenTo(this.collection, "add remove reset", this.render);
                this.currentUserName = AJS.Meta.get('remote-user') || '';
                if (options.showLikeButton === undefined) {
                    this.showLikeButton = true;
                }
                else {
                    this.showLikeButton = options.showLikeButton;
                }
            },

            render: function () {
                this.$el.empty();
                if (LikesManager.isLikable()) {
                    //Like option should only be displayed for licensed authenticated users
                    var remoteUserCanLike = this.currentUserName !== '' && AJS.Meta.get('remote-user-has-licensed-access') !== false;
                    var likesCount = this.collection.length;
                    var isLikedByUser = this.collection.isLikedByUser(this.currentUserName);
                    var html = Confluence.Templates.IC.likes({
                        showLikeButton: this.showLikeButton && remoteUserCanLike,
                        isLikedByUser: isLikedByUser,
                        likesCount: likesCount,
                        contentId: this.collection.contentId
                    });
                    this.$el.html(html);
                }
                return this;
            },

            toggleLike: function () {
                this.collection.toggleLike();
            }
        });
        return LikesView;
    }
);
