define('confluence/ic/view/confirm-dialog',
    [
        'backbone',
        'underscore',
        'jquery'
    ],
    function(
        Backbone,
        _,
        $
    ) {

    "use strict";

    var ConfirmDialog = Backbone.View.extend({

        tagName: 'div',

        className: 'ic-confirm-container',

        initialize: function(options) {
            // override the active menu class to provide css style
            this.$menuEl = options.$menuEl;
            this.$bodyEl = options.$bodyEl;

            this.$menuEl.addClass('ic-action-menu-active');
            this.render();
            // append handler to destroy if clicked outside
            _.bindAll(this, "clickOutside");
            this.$bodyEl.on('click', this.clickOutside);
        },

        events: {
            "click .ic-action-cancel-confirm" : "cancel",
            "click .ic-action-delete-confirm" : "confirm"
        },

        template: Confluence.Templates.IC.confirmDialog,

        render: function() {
            // FIX THIS
            // this.$el.css("top", (this.$menuEl.offset().top + this.$menuEl.height()) + "px");
            this.$el.html(this.template(this.model.toJSON()));
            return this;
        },

        clickOutside: function(e) {
            // don't close if click inside dialog
            if ($.contains(this.el, e.target) || this.el === e.target) {
                return;
            }
            this.cancel();
        },

        cancel: function() {
            this.destroy();
        },

        confirm: function() {
            // notify parent view the user confirmed delete action
            this.trigger("ic:confirm");
            this.destroy();
        },

        destroy: function() {
            // clean up events and style
            this.$bodyEl.off('click', this.clickOutside);
            this.$menuEl.removeClass('ic-action-menu-active');
            this.remove();
        }
    });

    return ConfirmDialog;
});