define('confluence/ic/app/loader',
[
    'jquery',
    'backbone',
    'ajs',
    'confluence/ic/model/comment',
    'confluence/ic/model/comment-collection',
    'confluence/ic/view/highlight-text',
    'confluence/ic/view/sidebar',
    'confluence/ic/view/resolved-comment-list',
    'confluence/ic/util/text-highlighter',
    'confluence/ic/util/utils',
    'confluence/ic/analytics',
    'confluence/ic/likes/likes-manager'
],
function(
    $,
    Backbone,
    AJS,
    Comment,
    CommentCollection,
    HighlightTextView,
    SidebarView,
    ResolvedCommentListView,
    TextHighlighter,
    Utils,
    Analytics,
    LikesManager
) {

    "use strict";

    var commentCollection = null;

    var Loader = {

        init: function(loadedCommentCollection) {
            commentCollection = loadedCommentCollection;

            // Generate the sidebar
            var sidebar = new SidebarView({
                $wikiContent: $('#content .wiki-content').first()
            });
            Utils.getPageContainer().append(sidebar.$el);
            // End generate the sidebar

            new HighlightTextView({
                collection: commentCollection
            }).render(); // render() HACK: fix me;

            // start likes plugin integration
            if (Confluence && Confluence.Likes && Confluence.Likes.getLikesCache) {
                Confluence.Likes.getLikesCache().done(function(likesCache) {
                    LikesManager.init(likesCache);
                    Backbone.trigger("ic:likes-received");
                });
            }
            // end likes plugin integration

            if (!Utils.getDarkFeatures().INLINE_COMMENTS) {
                return;
            }
        },

        loadSidebarOnClick: function(selectionObject){
            if (Utils.confirmProcess()) {
                Backbone.trigger("ic:highlight-panel-click");

                /*
                 * Also did not implement scrolling the window to the focused comment and displaying it in the
                 * sidebar on page load #focusedComment=12342311 in the address bar.
                 */

                // Fix this hack, we don't want to manipulate the dom directly anywhere but the views.
                // In our Comment model, we set the "active" attribute to true, which causes the highlight view
                // to re-render one of the highlights with an "active" css class
                $('.inline-comment-marker').removeClass('active');

                // If the current selection overlaps an existing highlight, clear the selection and
                // display the highlight's comment otherwise, create a new comment for the selected text
                var overlappedComment = Utils.overlappedSelection(selectionObject, commentCollection);
                if (overlappedComment) {
                    var $commentHighlight = $('.inline-comment-marker[data-ref="' + overlappedComment.get("markerRef") + '"]');
                    Confluence.HighlightAction.clearTextSelection();
                    overlappedComment.highlight = $commentHighlight; // need to set highlight on the model
                    Backbone.trigger("ic:overlap", overlappedComment);
                } else {
                    var serializedHighlights = (new TextHighlighter()).removeHighlight().highlight(selectionObject.range);
                    Backbone.trigger("ic:create", commentCollection, selectionObject, serializedHighlights);
                }
            }
        },

        updateResolvedCommentCountInToolsMenu: function() {
            var $viewResolvedCommentsDisplay = $('#view-resolved-comments>span');
            $viewResolvedCommentsDisplay.text(AJS.I18n.getText('inline.comments.resolved.view.menu') +
                AJS.format(' ({0})', commentCollection.getResolvedCount()));
        },
        
        afterSyncCommentCollection: function(){
            var loader = this;
            commentCollection.once("sync", function(collection) {
                loader.displayPermalinkedComment(collection);
            });
            
            commentCollection.on('change:resolveProperties', function() {
                loader.updateResolvedCommentCountInToolsMenu();
            });
            this.updateResolvedCommentCountInToolsMenu();
        },

        displayPermalinkedComment: function(collection){
            // ToDo: find a better way to mock window.location.search
            // need to pass queryString into showFocusedComment in order to make code unit testable
            var queryString = window.location.search;
            Utils.showFocusedComment(collection, queryString, ResolvedCommentListView);
        },
        
        createResolvedCommentListView: function() {
            new ResolvedCommentListView({
                collection: commentCollection
            }).render();
        }
    };

    return Loader;
});