/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.rest;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.SpacesWithAdminPermissionProvider;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.hipchat.api.Result;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/spaces")
public class SpaceToRoomSpaceResource {
    public static final int MAX_RESULTS_SIZE = 75;
    public static final int MINIMUM_QUERY_LENGTH = 1;
    private SpacesWithAdminPermissionProvider defaultSpacesWithAdminPermissionProvider;

    public SpaceToRoomSpaceResource(SpacesWithAdminPermissionProvider defaultSpacesWithAdminPermissionProvider) {
        this.defaultSpacesWithAdminPermissionProvider = defaultSpacesWithAdminPermissionProvider;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getSpaces(@QueryParam(value="name") String name) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (StringUtils.isBlank((CharSequence)name) || name.length() < 1) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Parameter 'name' must have at least 2 characters").build();
        }
        Result<Iterable<SpacesWithAdminPermissionProvider.SpaceResult>> spaces = this.defaultSpacesWithAdminPermissionProvider.findSpacesMatchingName(name, user, 75);
        if (spaces.isError()) {
            return Response.serverError().entity((Object)spaces.error().getMessage()).build();
        }
        return Response.ok((Object)spaces.success()).build();
    }
}

