/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.model;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.HipChatSynchronisationTaskConsumer;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.SynchronisationGoal;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectSynchronisationTasks {
    private static final long MAX_ITERATION_PERIOD_MillISECONDS = 5000L;
    private static final long RESCHEDULE_DELAY_MillISECONDS = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ConnectSynchronisationTasks.class);
    private static final ConnectSynchronisationTasks singleton = new ConnectSynchronisationTasks();
    private final AtomicLong versionRef = new AtomicLong(0L);
    private final Map<String, SynchronisationGoal> roomIdsToGoals = new ConcurrentHashMap<String, SynchronisationGoal>();

    private ConnectSynchronisationTasks() {
    }

    public static ConnectSynchronisationTasks getInstance() {
        return singleton;
    }

    public boolean hasTasks() {
        return this.roomIdsToGoals.size() > 0;
    }

    public long getVersion() {
        return this.versionRef.get();
    }

    public void clearTasks() {
        this.versionRef.incrementAndGet();
        this.roomIdsToGoals.clear();
    }

    public void addTasks(Set<String> roomIds, SynchronisationGoal synchronisationGoal) {
        this.versionRef.incrementAndGet();
        for (String roomId : roomIds) {
            this.roomIdsToGoals.put(roomId, synchronisationGoal);
        }
    }

    public <Context> void iteratePendingTasks(IterationKey iterationKey, HipChatSynchronisationTaskConsumer<Context> consumer, Context context) {
        long startTime = System.currentTimeMillis();
        long timeoutTime = startTime + 5000L;
        int initialCount = this.roomIdsToGoals.size();
        if (logger.isInfoEnabled()) {
            logger.info("Iterating over " + initialCount + " rooms requiring synchronisation...");
        }
        int successCount = 0;
        for (Map.Entry<String, SynchronisationGoal> entry : this.roomIdsToGoals.entrySet()) {
            boolean success;
            SynchronisationGoal synchronisationGoal = entry.getValue();
            if (!iterationKey.isValid()) {
                if (!logger.isInfoEnabled()) break;
                logger.info("Breaking synchronisation iteration due to model version change.");
                break;
            }
            String roomId = entry.getKey();
            if (logger.isInfoEnabled()) {
                logger.info("Performing " + (Object)((Object)synchronisationGoal) + " synchronisation for room " + roomId + ".");
            }
            if (success = consumer.processSynchronisationTask(roomId, synchronisationGoal, context)) {
                boolean removed = this.roomIdsToGoals.remove(roomId, (Object)synchronisationGoal);
                if (!removed) break;
                ++successCount;
            } else {
                int remainingCount = this.roomIdsToGoals.size();
                logger.warn("Synchronisation failure causing iteration to terminate early (successCount = " + successCount + ", initialCount = " + initialCount + ", remainingCount = " + remainingCount + ").");
                break;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime <= timeoutTime) continue;
            if (logger.isInfoEnabled()) {
                logger.info("Detected iteration lasted too long so re-scheduling...");
            }
            consumer.reschedule(1L, TimeUnit.MILLISECONDS);
            break;
        }
        if (logger.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - startTime;
            logger.debug("Finished iterating. successCount = " + successCount + ", duration = " + duration + "ms");
        }
    }

    public static final class IterationKey {
        private final ConnectSynchronisationTasks synchronisationTasks = ConnectSynchronisationTasks.getInstance();
        private final long modelVersion = ConnectSynchronisationTasks.access$000(this.synchronisationTasks).incrementAndGet();

        public boolean isValid() {
            return this.modelVersion == this.synchronisationTasks.versionRef.get();
        }
    }
}

