/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications.SpaceToRoomNotificationProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSpaceToRoomService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPIService;
import com.atlassian.plugins.hipchat.api.routes.HipChatRoutesProvider;
import com.atlassian.plugins.hipchat.api.user.HipChatUserFinder;
import com.atlassian.plugins.hipchat.descriptor.HipChatScopesManager;
import com.atlassian.plugins.hipchat.descriptor.InstallationCheckResult;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Map;

public class HipChatGlobalAdminDataProvider
implements ContextProvider {
    private final HipChatSpaceToRoomService spaceToRoomService;
    private final UserManager userManager;
    private final HipChatUserFinder hipChatUserFinder;
    private final HipChatScopesManager hipChatScopesManager;
    private final SpaceToRoomNotificationProvider spaceToRoomNotificationProvider;
    private final HipChatCompatAPIService hipChatCompatAPIService;
    private final HipChatRoutesProvider hipChatRoutesProvider;

    public HipChatGlobalAdminDataProvider(HipChatSpaceToRoomService spaceToRoomService, UserManager userManager, HipChatUserFinder hipChatUserFinder, HipChatScopesManager hipChatScopesManager, SpaceToRoomNotificationProvider spaceToRoomNotificationProvider, HipChatCompatAPIService hipChatCompatAPIService, HipChatRoutesProvider hipChatRoutesProvider) {
        this.spaceToRoomService = spaceToRoomService;
        this.userManager = userManager;
        this.hipChatUserFinder = hipChatUserFinder;
        this.hipChatScopesManager = hipChatScopesManager;
        this.spaceToRoomNotificationProvider = spaceToRoomNotificationProvider;
        this.hipChatCompatAPIService = hipChatCompatAPIService;
        this.hipChatRoutesProvider = hipChatRoutesProvider;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        String findInviteUsersURI = this.hipChatRoutesProvider.getFindInviteUsersURI().toString();
        String adminConfigurationPageURI = this.hipChatRoutesProvider.getAdminConfigurationPage().toString();
        String uninstallURI = this.hipChatRoutesProvider.getUninstall().toString();
        context.put("configs", this.spaceToRoomService.getAllSpaceToRoomConfigurations());
        context.put("hipChatUserName", this.getHipChatUserName());
        InstallationCheckResult installationCheckResult = this.hipChatScopesManager.requiresManualLinkReinstallation();
        context.put("reinstallationNeeded", installationCheckResult.isRequired());
        context.put("reinstallationReasonTitle", installationCheckResult.getReasonTitle());
        context.put("reinstallationReasonText", installationCheckResult.getReasonText());
        context.put("notificationTypes", this.spaceToRoomNotificationProvider.getNotificationTypes("space"));
        context.put("apiVersion", this.hipChatCompatAPIService.getCurrentVersion());
        context.put("findInviteUsersURI", findInviteUsersURI);
        context.put("adminConfigurationPageURI", adminConfigurationPageURI);
        context.put("uninstallURI", uninstallURI);
        return context;
    }

    public String getHipChatUserName() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            return null;
        }
        Option hipChatUser = this.hipChatUserFinder.findHipChatUserIdAndName(user.getUserKey());
        if (hipChatUser.isEmpty()) {
            return null;
        }
        return (String)((Pair)hipChatUser.get()).right();
    }
}

