define('confluence/hipchat/integration/hipchat/discovery/popup',
    [
    'jquery'
    ], function(
        $
) {
    return {
        /**
         *
         * @param {{featureKey:string,
         *  analytics:string,
         *  template:function,
         *  shouldShow:function,
         *  name:string,
         *  target: jQuery,
         *  onAccept: function,
         *  onDismiss: function }} opts
         */
        show : function(opts) {
            var shouldShow, pluginDiscovery;
            var featureKey = opts.featureKey;
            if (opts.shouldShow() && Confluence.FeatureDiscovery) {
                pluginDiscovery = Confluence.FeatureDiscovery.forPlugin(opts.pluginKey);
                shouldShow = pluginDiscovery.shouldShow(opts.featureKey, true);
            } else {
                shouldShow = false;
            }

            if (shouldShow) {

                AJS.trigger('analyticsEvent', {name: opts.analytics + '.view', data: {}});

                pluginDiscovery && pluginDiscovery.addDiscoveryView(featureKey);

                var dialog;

                var acceptDialog = function () {
                    pluginDiscovery && pluginDiscovery.markDiscovered(featureKey);
                    dialog.hide();
                    AJS.trigger('analyticsEvent', {name: opts.analytics + '.accept', data: {}});

                    if ($.isFunction(opts.onAccept)) {
                        opts.onAccept();
                    }
                };

                var dismissDialog = function (content) {
                    return function(event) {
                        event.preventDefault();
                        pluginDiscovery && pluginDiscovery.markDiscovered(featureKey);
                        dialog.hide();
                        content.parent().remove();

                        AJS.trigger('analyticsEvent', {name: opts.analytics + '.dismiss', data: {}});

                        if ($.isFunction(opts.onDismiss)) {
                            opts.onDismiss();
                        }
                    }
                };

                dialog = AJS.InlineDialog(opts.target, opts.name,
                        function (content, trigger, showPopup) {
                            content.html(opts.template({}));

                            showPopup();

                            //Bind handlers and apply styles
                            var parent = content.parent();

                            parent.addClass("hipchat-integration-discovery");

                            if (opts.fixed === true) {
                                parent.addClass("hipchat-integration-discovery-fixed");
                            }

                            content.find("#hipchat-integration-discovery-open").click(acceptDialog);

                            content.find("#hipchat-integration-discovery-dismiss").click(dismissDialog(content));
                        }
                        , {noBind: true});

                dialog.show();

                if (opts.fixed === true) {
                    // For fixed inline dialog recalculate position on window resize
                    $(window).resize(function () {
                        dialog.refresh();
                    });
                }
            }
        }
    };
});