/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.discovery;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSpaceToRoomService;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.user.User;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HipChatSpaceAdminDataProvider
implements ContextProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HipChatSpaceAdminDataProvider.class);
    private final SpacePermissionManager spacePermissionManager;
    private final HipChatSpaceToRoomService spaceToRoomService;

    public HipChatSpaceAdminDataProvider(SpacePermissionManager spacePermissionManager, HipChatSpaceToRoomService spaceToRoomService) {
        this.spacePermissionManager = spacePermissionManager;
        this.spaceToRoomService = spaceToRoomService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        Object contextAction = context.get("action");
        if (contextAction instanceof ConfluenceActionSupport) {
            ConfluenceActionSupport actionSupport = (ConfluenceActionSupport)contextAction;
            WebInterfaceContext interfaceContext = actionSupport.getWebInterfaceContext();
            ConfluenceUser user = interfaceContext.getCurrentUser();
            Space space = interfaceContext.getSpace();
            if (space != null && user != null && !space.isPersonal()) {
                boolean isSpaceAdmin = this.spacePermissionManager.hasPermission("SETSPACEPERMISSIONS", space, (User)user);
                boolean hasSpaceConfiguration = isSpaceAdmin && this.spaceToRoomService.hasSpaceToRoomConfiguration(space.getKey());
                context.put("isSpaceAdmin", isSpaceAdmin);
                context.put("hasSpaceConfig", hasSpaceConfiguration);
            }
        }
        return context;
    }
}

