/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.HipChatRoomDefinition;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.RoomProvider;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.rooms.CollapsedRoom;
import com.atlassian.hipchat.api.rooms.ExpandedRoom;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPI;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedHipChatApiRoomProvider
implements RoomProvider {
    private static final Logger logger = LoggerFactory.getLogger(BatchedHipChatApiRoomProvider.class);
    private static final int MAX_ROOM_WAIT_MS = 15000;
    private final Map<String, Result<ExpandedRoom>> roomIdToRoom;

    private BatchedHipChatApiRoomProvider(Map<String, Result<ExpandedRoom>> roomIdToRoom) {
        this.roomIdToRoom = Collections.unmodifiableMap(roomIdToRoom);
    }

    public static RoomProvider createFromRoomIds(HipChatCompatAPI api, Set<String> roomIds) {
        return new BatchedHipChatApiRoomProvider(BatchedHipChatApiRoomProvider.loadRoomDetails(api, roomIds));
    }

    private static Map<String, Result<ExpandedRoom>> loadRoomDetails(HipChatCompatAPI api, Set<String> roomIds) {
        Map<String, Result<ExpandedRoom>> rooms;
        block5: {
            Preconditions.checkNotNull((Object)api);
            Preconditions.checkNotNull(roomIds);
            rooms = null;
            try {
                rooms = (Map<String, Result<ExpandedRoom>>)api.expandRoomsForIds(roomIds).get(15000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                logger.warn("Timed out waiting for full list of rooms. Rooms may not have valid names.", (Throwable)ex);
                if (logger.isDebugEnabled()) {
                    logger.debug("Debugging details", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                logger.warn("Encountered error while waiting for full list of rooms. Rooms may no have valid names.", (Throwable)ex);
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Debugging details", (Throwable)ex);
            }
        }
        if (rooms == null) {
            rooms = Collections.emptyMap();
        }
        return rooms;
    }

    @Override
    public HipChatRoomDefinition getRoom(String roomId) {
        HipChatRoomDefinition room;
        Result<ExpandedRoom> roomResult = this.roomIdToRoom.get(roomId);
        if (roomResult != null && roomResult.isSuccess()) {
            ExpandedRoom success = (ExpandedRoom)roomResult.success();
            room = new HipChatRoomDefinition((CollapsedRoom)success);
        } else if (roomResult != null) {
            HipChatRoomDefinition.RoomState status = HipChatRoomDefinition.RoomState.fromStatusCode(roomResult.error().getStatusCode());
            room = new HipChatRoomDefinition("Room #" + roomId, roomId, true, status);
        } else {
            room = new HipChatRoomDefinition("Room #" + roomId, roomId, true, HipChatRoomDefinition.RoomState.NotFound);
        }
        return room;
    }
}

