/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.actions;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import com.atlassian.plugins.hipchat.install.HipChatLinkState;
import java.util.Map;

@Internal
public class ViewSpaceInstallationAction
extends AbstractSpaceAdminAction {
    private static final String CONTEXT_ATTRIBUTE_LABEL = "context";
    private String installableUrl = "";
    private String redirectUrl = "";
    private boolean isUninstall = false;
    private boolean isInstalling = false;
    private HipChatLinkState state = HipChatLinkState.NOT_INSTALLED;

    public String execute() throws Exception {
        Map contextFromSession = (Map)this.getSession().get(CONTEXT_ATTRIBUTE_LABEL);
        if (contextFromSession != null) {
            this.setInstallableUrl((String)contextFromSession.get("installableUrl"));
            this.setRedirectUrl((String)contextFromSession.get("redirectUrl"));
            this.setState((HipChatLinkState)contextFromSession.get("state"));
            this.setInstalling(this.state == HipChatLinkState.INSTALLING);
            this.setUninstall(this.state == HipChatLinkState.UNINSTALLING);
            this.getSession().remove(CONTEXT_ATTRIBUTE_LABEL);
        }
        this.getSession().put("hipchat.integration.attribute.from.space", true);
        this.getSession().put("hipchat.integration.attribute.space.key", this.getSpaceKey());
        return "success";
    }

    public String getInstallableUrl() {
        return this.installableUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public boolean isUninstall() {
        return this.isUninstall;
    }

    public boolean isInstalling() {
        return this.isInstalling;
    }

    public void setInstallableUrl(String installableUrl) {
        this.installableUrl = installableUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setUninstall(boolean isUninstall) {
        this.isUninstall = isUninstall;
    }

    public void setInstalling(boolean isInstalling) {
        this.isInstalling = isInstalling;
    }

    public HipChatLinkState getState() {
        return this.state;
    }

    public void setState(HipChatLinkState state) {
        this.state = state;
    }
}

