define("confluence-hipchat-emoticons/dialog/EmoticonDialog",
    [
        "ajs",
        "jquery",
        "rivets",
        "underscore",
        "confluence-hipchat-emoticons/dialog/DialogEmoticon",
        "confluence-hipchat-emoticons/dialog/EmoticonDialogModel",
        "confluence-hipchat-emoticons/dialog/Templates"
    ],
    function (
        AJS,
        $,
        rivets,
        _,
        DialogEmoticon,
        EmoticonDialogModel,
        Templates) {

        var EmoticonDialog = function () {
            var self = this,
                boundView = null;

            var model = new EmoticonDialogModel({
                dialog: this
            });

            var emoticonDialog = $(Templates.emoticonDialog({auiVersion: parseInt(AJS.version)}))[0];

            // Setup dialog.
            document.body.appendChild(emoticonDialog);
            this._dialog = AJS.dialog2(emoticonDialog);

            boundView = rivets.bind(emoticonDialog, model);

            $(emoticonDialog.querySelector(".loading-spinner")).spin("large");

            this._dialog.on("show", function() {
                model.update(model.filterText = "");
            });
        };

        _.extend(EmoticonDialog.prototype, {
            show: function () {
                this._dialog.show();
            },

            close: function () {
                this._dialog.hide();
            }
        });

        return EmoticonDialog;
    });
