define("confluence-hipchat-emoticons/dialog/EmoticonDialogModel",
    [
        "ajs",
        "underscore",
        "confluence-hipchat-emoticons/data/DataManager",
        "confluence-hipchat-emoticons/insertion/EmoticonInserter",
        "confluence-hipchat-emoticons/dialog/DialogEmoticon"
    ],
    function (
        AJS,
        _,
        DataManager,
        EmoticonInserter,
        DialogEmoticon) {

        var EmoticonDialogModel = function (options) {
            var self = this;

            this.close = function() {
                options.dialog.close();
            };

            this.onFilterSubmit = function(ev) {
                return ev.preventDefault();
            };

            this.onFilterUpdate = function() {
                self.update(this.value);
            };

            var onConfluenceEmoticonClick = function (emoticon) {
                EmoticonInserter.insertEmoticon(emoticon);
                self.close();
            };

            var onHipchatEmoticonClick = function (emoticon) {
                EmoticonInserter.insertEmoticon(emoticon, "gallery");
                self.close();
            };

            this.isAdmin = AJS.Meta.getBoolean("is-admin");
            this.isHipChatIntegrated = false;

            this.loadEmoticons = function() {
                var promise = self.isError ? DataManager.loadRemoteData() : DataManager.getAuthoritativeEmoticons();

                self.isLoading = true;
                self.isError = false;
                self.showEmoticons = false;
                self.showHipChatEmoticons = false;

                promise.then(function(data) {
                    self.isLoading = false;

                    self.hipchatEmoticons = data.hipchat.map(function(emoticon) {
                        return new DialogEmoticon({
                            shortcut: emoticon.shortcut,
                            fullShortcut: "(" + emoticon.shortcut + ")",
                            url: emoticon.url,
                            onClick: onHipchatEmoticonClick
                        });
                    });

                    self.confluenceEmoticons = data.confluence.map(function(emoticon) {
                        return new DialogEmoticon({
                            name: emoticon.name,
                            shortcut: emoticon.shortcut,
                            fullShortcut: emoticon.shortcut,
                            url: emoticon.url,
                            onClick: onConfluenceEmoticonClick
                        });
                    });

                    self.showEmoticons = true;
                    self.showHipChatEmoticons = Boolean(AJS.Meta.get("remote-user"));
                    self.allEmoticons = _.union(self.confluenceEmoticons, self.hipchatEmoticons);
                    self.isHipChatIntegrated = data.hipchatIntegrated;

                    setTimeout(function() {
                        document.querySelector("#hipchat-emoticons-filter").focus();
                        document.querySelector("#hipchat-emoticons-filter").select();
                    }, 100);
                }).fail(function() {
                    self.isError = true;
                    self.isLoading = false;
                });
            }.bind(this);

            this.loadEmoticons();
        };

        EmoticonDialogModel.prototype.update = function(filterText) {
            if (this._previousFilterText === filterText) {
                return;
            }

            this._previousFilterText = filterText;

            (this.allEmoticons || []).forEach(function(emoticon) {
                emoticon.visible = emoticon.fullShortcut.indexOf(filterText) >= 0;
            });
        };

        return EmoticonDialogModel;
    });
