/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailtracker;

import com.atlassian.confluence.plugins.emailtracker.EmailTrackerService;
import com.atlassian.confluence.plugins.emailtracker.InvalidTrackingRequestException;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class EmailTrackerServlet
extends HttpServlet {
    private final EmailTrackerService tracker;

    public EmailTrackerServlet(EmailTrackerService tracker) {
        this.tracker = tracker;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            Map<String, String> params = this.extractParams(req.getParameterMap());
            String urlToQuery = req.getRequestURL().toString();
            this.tracker.handleTrackingRequest(urlToQuery, params);
            this.writeResponse(httpServletResponse);
        }
        catch (InvalidTrackingRequestException e) {
            httpServletResponse.sendError(400, "Invalid tracking request: " + req.getRequestURI());
        }
        catch (Exception ex) {
            httpServletResponse.sendError(500);
        }
    }

    private Map<String, String> extractParams(Map<String, String[]> parameterMap) {
        HashMap params = Maps.newHashMap();
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            params.put(entry.getKey(), entry.getValue()[0]);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(HttpServletResponse httpServletResponse) throws IOException {
        InputStream inputStream = null;
        ServletOutputStream responseOutputStream = null;
        httpServletResponse.setContentType("image/png");
        try {
            inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/images/trackback.png");
            responseOutputStream = httpServletResponse.getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)responseOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(responseOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)responseOutputStream);
    }
}

