/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.mail.ConfluencePopMailServer;
import com.atlassian.confluence.plugins.emailgateway.api.EmailGatewaySettingsManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.user.User;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import java.util.List;
import java.util.Optional;

public class EmailGatewayAdminAction
extends ConfluenceActionSupport {
    private boolean allowToCreatePageByEmail;
    private boolean allowToCreateCommentByEmail;
    private long selectedPopMailServerId;
    private ConfluencePopMailServer popMailServer;
    private EmailGatewaySettingsManager emailGatewaySettingsManager;
    private MailServerManager mailServerManager;
    private boolean updated = false;
    private boolean error = false;

    public boolean isPermitted() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        this.readConfigData();
        return "success";
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String processSubmit() {
        this.applyFormData();
        if (this.popMailServer != null) {
            this.emailGatewaySettingsManager.setAllowToCreatePageByEmail(this.allowToCreatePageByEmail);
            this.emailGatewaySettingsManager.setAllowToCreateCommentByEmail(this.allowToCreateCommentByEmail);
            this.emailGatewaySettingsManager.setDefaultPopServer(this.popMailServer);
            return "success";
        }
        return "error";
    }

    public boolean isAllowToCreatePageByEmail() {
        return this.allowToCreatePageByEmail;
    }

    public void setAllowToCreatePageByEmail(boolean allowToCreatePageByEmail) {
        this.allowToCreatePageByEmail = allowToCreatePageByEmail;
    }

    public boolean isAllowToCreateCommentByEmail() {
        return this.allowToCreateCommentByEmail;
    }

    public void setAllowToCreateCommentByEmail(boolean allowToCreateCommentByEmail) {
        this.allowToCreateCommentByEmail = allowToCreateCommentByEmail;
    }

    public long getSelectedPopMailServerId() {
        return this.selectedPopMailServerId;
    }

    public void setSelectedPopMailServerId(long selectedPopMailServerId) {
        this.selectedPopMailServerId = selectedPopMailServerId;
    }

    public ConfluencePopMailServer getPopMailServer() {
        return this.popMailServer;
    }

    public void setPopMailServer(ConfluencePopMailServer popMailServer) {
        this.popMailServer = popMailServer;
    }

    public void setEmailGatewaySettingsManager(EmailGatewaySettingsManager emailGatewaySettingsManager) {
        this.emailGatewaySettingsManager = emailGatewaySettingsManager;
    }

    public void setMailServerManager(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setUpdated(boolean updated) {
        this.updated = updated;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    private void readConfigData() {
        this.allowToCreatePageByEmail = this.emailGatewaySettingsManager.isAllowToCreatePageByEmail();
        this.allowToCreateCommentByEmail = this.emailGatewaySettingsManager.isAllowToCreateCommentByEmail();
        this.popMailServer = this.emailGatewaySettingsManager.getDefaultPopServer();
        if (this.popMailServer == null) {
            this.popMailServer = (ConfluencePopMailServer)this.mailServerManager.getDefaultPopMailServer();
        } else {
            Optional<PopMailServer> selectedMailServer = this.getAllPopMailServer().stream().filter(mailServer -> mailServer.getId().equals(this.popMailServer.getId())).findFirst();
            this.popMailServer = (ConfluencePopMailServer)selectedMailServer.orElse(this.mailServerManager.getDefaultPopMailServer());
        }
        if (this.popMailServer != null) {
            this.selectedPopMailServerId = this.popMailServer.getId();
        }
    }

    public List<PopMailServer> getAllPopMailServer() {
        return this.mailServerManager.getPopMailServers();
    }

    private void applyFormData() {
        Optional<PopMailServer> selectedMailServer = this.getAllPopMailServer().stream().filter(mailServer -> mailServer.getId().equals(this.selectedPopMailServerId)).findFirst();
        this.popMailServer = selectedMailServer.orElse(null);
    }
}

