/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.service;

import com.atlassian.confluence.plugins.emailgateway.api.EmailHandlingException;
import com.atlassian.confluence.plugins.emailgateway.api.ReceivedEmail;
import com.atlassian.confluence.plugins.emailgateway.polling.EmailPoller;
import com.atlassian.confluence.plugins.emailgateway.polling.EmailPollingException;
import com.atlassian.confluence.plugins.emailgateway.service.BulkEmailProcessingService;
import com.atlassian.confluence.plugins.emailgateway.service.EmailHandlerService;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkPollingEmailProcessingService
implements BulkEmailProcessingService {
    private static final Logger log = LoggerFactory.getLogger(BulkPollingEmailProcessingService.class);
    private final EmailPoller emailPoller;
    private final EmailHandlerService emailHandlerService;

    public BulkPollingEmailProcessingService(EmailPoller emailPoller, EmailHandlerService emailHandlerService) {
        this.emailPoller = emailPoller;
        this.emailHandlerService = emailHandlerService;
    }

    @Override
    public boolean isAvailable() {
        return this.emailPoller.isAvailable();
    }

    @Override
    public int processInboundEmail() {
        try {
            Collection<ReceivedEmail> receivedMessages = this.emailPoller.pollForIncomingEmails();
            log.debug("Received {} messages", (Object)receivedMessages.size());
            int processedEmails = 0;
            for (ReceivedEmail receivedMessage : receivedMessages) {
                try {
                    this.emailHandlerService.handle(receivedMessage);
                    ++processedEmails;
                }
                catch (EmailHandlingException e) {
                    log.warn("Unable to handle received email", (Throwable)e);
                }
            }
            log.debug("Processed {} messages", (Object)processedEmails);
            return processedEmails;
        }
        catch (EmailPollingException e) {
            log.error("Failed to poll mail server", (Throwable)e);
            return 0;
        }
    }
}

