/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.rest;

import com.atlassian.confluence.plugins.emailgateway.service.BulkEmailProcessingService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class EmailGatewayResource {
    private static final Logger log = LoggerFactory.getLogger(EmailGatewayResource.class);
    private final BulkEmailProcessingService emailThreadConverterProcessingService;
    private final PermissionManager permissionManager;

    public EmailGatewayResource(BulkEmailProcessingService emailThreadConverterProcessingService, PermissionManager permissionManager) {
        this.emailThreadConverterProcessingService = emailThreadConverterProcessingService;
        this.permissionManager = permissionManager;
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/runEmailHandlers")
    @Consumes(value={"application/json"})
    public Response runEmailConverter() {
        if (!this.permissionManager.isConfluenceAdministrator((User)AuthenticatedUserThreadLocal.get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        log.info("Processing inbound emails");
        int numProcessed = this.emailThreadConverterProcessingService.processInboundEmail();
        HashMap result = Maps.newHashMap();
        result.put("numProcessed", numProcessed);
        return Response.ok((Object)result).build();
    }
}

